/*
 * Decompiled with CFR 0.152.
 */
package com.adarshr.gradle.testlogger.theme;

import com.adarshr.gradle.testlogger.TestDescriptorWrapper;
import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.TestResultWrapper;
import com.adarshr.gradle.testlogger.theme.AbstractTheme;
import com.adarshr.gradle.testlogger.theme.ThemeType;
import com.adarshr.gradle.testlogger.util.RendererUtils;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.tasks.testing.TestResult;

public class MochaTheme
extends AbstractTheme {
    private ThemeType type;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    protected MochaTheme(TestLoggerExtension extension) {
        super(extension);
        ThemeType themeType;
        this.type = themeType = ThemeType.MOCHA;
    }

    @Override
    protected String suiteTextInternal(TestDescriptorWrapper descriptor) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{descriptor.getClassDisplayName(), System.lineSeparator()}, new String[]{"  [erase-ahead,default]", "[/]", ""}));
    }

    @Override
    protected String testTextInternal(TestDescriptorWrapper descriptor, TestResultWrapper result) {
        return this.testTextInternal("    [erase-ahead]", descriptor, result);
    }

    protected String testTextInternal(String start, TestDescriptorWrapper descriptor, TestResultWrapper result) {
        StringBuilder line;
        block1: {
            TestResult.ResultType resultType;
            block2: {
                block0: {
                    line = new StringBuilder(start);
                    resultType = result.getResultType();
                    if (!ScriptBytecodeAdapter.isCase((Object)resultType, (Object)TestResult.ResultType.SUCCESS)) break block0;
                    StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{MochaTheme.getSymbol(result.getResultType()), descriptor.getDisplayName()}, new String[]{"[green]", "[grey] ", ""}));
                    MochaTheme.showDurationIfSlow(result, line);
                    break block1;
                }
                if (!ScriptBytecodeAdapter.isCase((Object)resultType, (Object)TestResult.ResultType.FAILURE)) break block2;
                StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{MochaTheme.getSymbol(result.getResultType()), descriptor.getDisplayName()}, new String[]{"[red]", " ", ""}));
                MochaTheme.showDurationIfSlow(result, line);
                StringGroovyMethods.leftShift((StringBuilder)line, (Object)this.exceptionText(descriptor, result));
                break block1;
            }
            if (!ScriptBytecodeAdapter.isCase((Object)resultType, (Object)TestResult.ResultType.SKIPPED)) break block1;
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{MochaTheme.getSymbol(result.getResultType()), descriptor.getDisplayName()}, new String[]{"[cyan]", " ", ""}));
        }
        return ShortTypeHandling.castToString((Object)StringGroovyMethods.leftShift((StringBuilder)line, (Object)"[/]"));
    }

    private static void showDurationIfSlow(TestResultWrapper result, StringBuilder line) {
        if (result.isTooSlow()) {
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{result.getDuration()}, new String[]{"[red] (", ")"}));
        } else if (result.isMediumSlow()) {
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{result.getDuration()}, new String[]{"[yellow] (", ")"}));
        }
    }

    private static String getSymbol(TestResult.ResultType resultType) {
        TestResult.ResultType resultType2 = resultType;
        if (ScriptBytecodeAdapter.isCase((Object)resultType2, (Object)TestResult.ResultType.SUCCESS)) {
            return MochaTheme.getWindows() ? "\u221a" : "\u2714";
        }
        if (ScriptBytecodeAdapter.isCase((Object)resultType2, (Object)TestResult.ResultType.FAILURE)) {
            return MochaTheme.getWindows() ? "X" : "\u2718";
        }
        if (ScriptBytecodeAdapter.isCase((Object)resultType2, (Object)TestResult.ResultType.SKIPPED)) {
            return "-";
        }
        return ShortTypeHandling.castToString(null);
    }

    private static boolean getWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    @Override
    public String exceptionText(TestDescriptorWrapper descriptor, TestResultWrapper result) {
        return this.exceptionText(descriptor, result, 6);
    }

    @Override
    protected String exceptionText(TestDescriptorWrapper descriptor, TestResultWrapper result, int indent) {
        String exceptionText = super.exceptionText(descriptor, result, indent);
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)exceptionText) ? new GStringImpl(new Object[]{exceptionText}, new String[]{"[red]", ""}) : ""));
    }

    @Override
    public String summaryText(TestDescriptorWrapper descriptor, TestResultWrapper result) {
        return this.summaryText(descriptor, result, 2);
    }

    protected String summaryText(TestDescriptorWrapper descriptor, TestResultWrapper result, int indent) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.extension.getShowSummary())) {
            return "";
        }
        String indentation = StringGroovyMethods.multiply((CharSequence)" ", (Number)indent);
        StringBuilder line = new StringBuilder();
        StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{indentation, result.getSuccessfulTestCount(), result.getDuration()}, new String[]{"", "[erase-ahead,green]", " passing [grey](", ")"}));
        if (result.getSkippedTestCount() != 0L) {
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{System.lineSeparator(), indentation, result.getSkippedTestCount()}, new String[]{"", "", "[erase-ahead,cyan]", " pending"}));
        }
        if (result.getFailedTestCount() != 0L) {
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{System.lineSeparator(), indentation, result.getFailedTestCount()}, new String[]{"", "", "[erase-ahead,red]", " failing"}));
        }
        return ShortTypeHandling.castToString((Object)StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"[/]", ""})));
    }

    @Override
    protected String suiteStandardStreamTextInternal(String lines) {
        return this.standardStreamTextInternal(lines, 4);
    }

    @Override
    protected String testStandardStreamTextInternal(String lines) {
        return this.standardStreamTextInternal(lines, 8);
    }

    protected String standardStreamTextInternal(String lines, int indent) {
        String string;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.extension.getShowStandardStreams()) || !DefaultTypeTransformation.booleanUnbox((Object)lines)) {
            return "";
        }
        lines = string = RendererUtils.escape(lines);
        Reference indentation = new Reference((Object)StringGroovyMethods.multiply((CharSequence)" ", (Number)indent));
        StringBuilder line = new StringBuilder((CharSequence)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"[grey]", ""}));
        public final class _standardStreamTextInternal_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference indentation;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _standardStreamTextInternal_closure1(Object _outerInstance, Object _thisObject, Reference indentation) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.indentation = reference = indentation;
            }

            public Object doCall(Object it) {
                return new GStringImpl(new Object[]{this.indentation.get(), it}, new String[]{"", "", ""});
            }

            @Generated
            public Object getIndentation() {
                return this.indentation.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _standardStreamTextInternal_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        StringGroovyMethods.leftShift((StringBuilder)line, (Object)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)lines.split(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"", ""}))), Object[].class)), (Closure)new _standardStreamTextInternal_closure1(this, this, indentation)), (String)System.lineSeparator()));
        return ShortTypeHandling.castToString((Object)StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"[/]", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MochaTheme.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Generated
    public ThemeType getType() {
        return this.type;
    }

    @Generated
    public void setType(ThemeType themeType) {
        this.type = themeType;
    }
}

