/*
 * Decompiled with CFR 0.152.
 */
package wssimulator.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wssimulator.WSSimulation;
import wssimulator.YamlToSimulation;
import wssimulator.scanner.CompositeFilter;
import wssimulator.scanner.SearchFilter;
import wssimulator.scanner.SimulationContentFilter;
import wssimulator.scanner.SimulationFilter;
import wssimulator.scanner.SimulationFilterType;

public class SimulationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(SimulationScanner.class);

    public static Collection<WSSimulation> classPathScanner(SimulationFilter simulationFilter) {
        List<SearchFilter> searchFilters = SimulationScanner.searchFilters(simulationFilter);
        Reflections reflections = new Reflections(SimulationScanner.packagePrefixFilter(searchFilters), new Scanner[]{new ResourcesScanner()});
        Set candidateClasspathLocations = reflections.getResources(Pattern.compile(SimulationScanner.regexFilter(searchFilters)));
        List<WSSimulation> candidateSimulations = SimulationScanner.classpathToSimulations(candidateClasspathLocations);
        Collection<WSSimulation> wsSimulations = SimulationScanner.filterSimulationsByContent(candidateSimulations, simulationFilter);
        LOG.info("matched {} simulations", (Object)wsSimulations.size());
        return wsSimulations;
    }

    private static Collection<WSSimulation> filterSimulationsByContent(List<WSSimulation> candidateSimulations, SimulationFilter simulationFilter) {
        ContentFilterPredicate contentFilterPredicate = new ContentFilterPredicate(SimulationScanner.simulationContentFilters(simulationFilter));
        return candidateSimulations.stream().filter(contentFilterPredicate).collect(Collectors.toList());
    }

    private static List<WSSimulation> classpathToSimulations(Collection<String> candidateClasspathList) {
        ArrayList<WSSimulation> list = new ArrayList<WSSimulation>();
        for (String classPath : candidateClasspathList) {
            WSSimulation wsSimulation;
            String readClasspathResourceQuietly = SimulationScanner.readClasspathResourceQuietly(classPath);
            if (!readClasspathResourceQuietly.contains("path:") || (wsSimulation = YamlToSimulation.toSimulation(classPath, readClasspathResourceQuietly)) == null) continue;
            list.add(wsSimulation);
        }
        return list;
    }

    @NotNull
    private static String regexFilter(@NotNull List<SearchFilter> searchFilters) {
        Optional<SearchFilter> regexFilter = searchFilters.stream().filter(searchFilter -> searchFilter.filterType() == SimulationFilterType.FilterByRegex).findFirst();
        return regexFilter.map(SearchFilter::filter).orElse(".*\\.yml");
    }

    @NotNull
    private static String packagePrefixFilter(@NotNull List<SearchFilter> searchFilters) {
        StringBuilder packageFilterString = new StringBuilder("");
        Optional<SearchFilter> regexFilter = searchFilters.stream().filter(searchFilter -> searchFilter.filterType() == SimulationFilterType.FilterByPackagePrefix).findFirst();
        regexFilter.ifPresent(searchFilter -> packageFilterString.append(searchFilter.filter()));
        return packageFilterString.toString();
    }

    @NotNull
    private static List<SearchFilter> searchFilters(@NotNull SimulationFilter filter) {
        if (filter instanceof CompositeFilter) {
            return ((CompositeFilter)filter).searchFilters();
        }
        if (filter instanceof SearchFilter) {
            return Collections.singletonList((SearchFilter)filter);
        }
        return new ArrayList<SearchFilter>();
    }

    @NotNull
    private static List<SimulationContentFilter> simulationContentFilters(@NotNull SimulationFilter filter) {
        if (filter instanceof CompositeFilter) {
            return ((CompositeFilter)filter).simulationContentFilters();
        }
        if (filter instanceof SimulationContentFilter) {
            return Collections.singletonList((SimulationContentFilter)filter);
        }
        return new ArrayList<SimulationContentFilter>();
    }

    public static String readClasspathResourceQuietly(String packageLocation) {
        try {
            InputStream resourceAsStream = SimulationScanner.class.getClassLoader().getResourceAsStream(packageLocation);
            return resourceAsStream == null ? "" : IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            LOG.info("Couldn't read file {}", (Object)packageLocation);
            return "";
        }
    }

    static class ContentFilterPredicate
    implements Predicate<WSSimulation> {
        private List<SimulationContentFilter> simulationContentFilters;

        public ContentFilterPredicate(List<SimulationContentFilter> simulationContentFilters) {
            this.simulationContentFilters = simulationContentFilters;
        }

        @Override
        public boolean test(WSSimulation wsSimulation) {
            for (SimulationContentFilter simulationContentFilter : this.simulationContentFilters) {
                if (!simulationContentFilter.include(wsSimulation)) continue;
                return true;
            }
            return false;
        }
    }
}

