/*
 * Decompiled with CFR 0.152.
 */
package wssimulator.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import wssimulator.RouteRequestFilterType;
import wssimulator.WSSimulation;
import wssimulator.WSSimulator;
import wssimulator.handler.ContainsRouteRequestFilterer;
import wssimulator.handler.NoneRouteRequestFilterer;
import wssimulator.handler.RouteRequestFilterer;
import wssimulator.scanner.SimulationScanner;

public class BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulator.class);
    private Map<RouteRequestFilterType, RouteRequestFilterer> filterTypes = new HashMap<RouteRequestFilterType, RouteRequestFilterer>(){
        {
            this.put(RouteRequestFilterType.contains, new ContainsRouteRequestFilterer());
            this.put(RouteRequestFilterType.none, new NoneRouteRequestFilterer());
        }
    };
    private final List<WSSimulation> wsSimulations = new ArrayList<WSSimulation>();
    private final Random random = new Random();

    public BaseHandler() {
    }

    public BaseHandler(@NotNull WSSimulation wsSimulations) {
        this.wsSimulations.add(wsSimulations);
    }

    @NotNull
    public final Object processRequest(@NotNull Request request, @NotNull Response response) {
        Map<String, String> params = this.buildParameterValues(request);
        LOG.info("request body:{}", (Object)request.body());
        WSSimulation wsSimulation = this.loadSimulation(request);
        if (wsSimulation != null) {
            wsSimulation.wsSimulationContext.simulationInvoked(request.body());
            this.latencyCheck(wsSimulation);
            LOG.info("returning with status code:{}", (Object)wsSimulation.responseCode);
            response.status(wsSimulation.responseCode);
            if (StringUtils.isNotEmpty((CharSequence)wsSimulation.response)) {
                return new StrSubstitutor(params).replace(this.loadResponse(wsSimulation));
            }
        }
        return "";
    }

    private String loadResponse(WSSimulation simulation) {
        if (!StringUtils.startsWith((CharSequence)simulation.response, (CharSequence)"wssimulatorRequest:")) {
            return simulation.response;
        }
        String requestFile = StringUtils.substringAfter((String)simulation.response, (String)"wssimulatorRequest:");
        String content = SimulationScanner.readClasspathResourceQuietly(requestFile);
        if (StringUtils.isEmpty((CharSequence)content)) {
            String classpath = FilenameUtils.getFullPathNoEndSeparator((String)simulation.onClassPath);
            content = SimulationScanner.readClasspathResourceQuietly(classpath + "/" + requestFile);
        }
        return content;
    }

    @Nullable
    private WSSimulation loadSimulation(@Nullable Request request) {
        Object wsSimulation = null;
        Collections.sort(this.wsSimulations, (o1, o2) -> Boolean.compare(o2.request.filterType == RouteRequestFilterType.none, o1.request.filterType == RouteRequestFilterType.none));
        ArrayList<WSSimulation> canidates = new ArrayList<WSSimulation>();
        for (WSSimulation simulation : this.wsSimulations) {
            if (!this.filterTypes.get((Object)simulation.request.filterType).filter(simulation, request)) continue;
            canidates.add(simulation);
        }
        Optional<WSSimulation> first = canidates.stream().sorted(Comparator.comparingInt(o -> o.priority)).findFirst();
        return first.orElse(null);
    }

    private void latencyCheck(@NotNull WSSimulation wsSimulation) {
        if (StringUtils.isNotEmpty((CharSequence)wsSimulation.latency)) {
            if (StringUtils.contains((CharSequence)wsSimulation.latency, (CharSequence)"-")) {
                long start = NumberUtils.toLong((String)StringUtils.substringBefore((String)wsSimulation.latency, (String)"-"), (long)0L);
                long end = NumberUtils.toLong((String)StringUtils.substringAfter((String)wsSimulation.latency, (String)"-"), (long)0L);
                long delay = RandomUtils.nextLong((long)start, (long)end);
                this.sleepFor(delay);
            }
            this.sleepFor(NumberUtils.toLong((String)wsSimulation.latency, (long)0L));
        }
    }

    private void sleepFor(long sleepFor) {
        try {
            Thread.sleep(sleepFor);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Map<String, String> buildParameterValues(@NotNull Request request) {
        Map<String, String> params = request.params().keySet().stream().collect(Collectors.toMap(p -> String.format("param.%s", p.substring(1)), arg_0 -> ((Request)request).params(arg_0)));
        return params;
    }

    public int routeCount() {
        return this.wsSimulations.size();
    }

    public void addRoute(@NotNull WSSimulation simulation) {
        this.wsSimulations.add(simulation);
    }
}

