/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wssimulator.WSSimulation;

public class YamlToSimulation {
    private static final Logger LOG = LoggerFactory.getLogger(YamlToSimulation.class);

    @Nullable
    public static WSSimulation toSimulation(String classPath, @NotNull String yamlString) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        WSSimulation simulation = null;
        try {
            simulation = (WSSimulation)mapper.readValue(yamlString, WSSimulation.class);
            simulation.onClassPath = classPath;
        }
        catch (Exception e) {
            LOG.info(String.format("Could not parse yaml started:(%s)", StringUtils.substring((String)yamlString, (int)0, (int)20)));
            LOG.info(String.format("Could not parse yaml:(%s)", yamlString), (Throwable)e);
        }
        return simulation;
    }
}

