/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;
import wssimulator.SimulationNotValidException;
import wssimulator.WSSimulation;

public class WSSimulatorValidation {
    public static void validate(@NotNull WSSimulation simulation) {
        if (StringUtils.isEmpty((CharSequence)simulation.path)) {
            throw new SimulationNotValidException(simulation);
        }
    }

    public static boolean validateXml(@NotNull String xsd, @NotNull String xml) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(IOUtils.toInputStream((String)xsd, (Charset)Charset.defaultCharset())));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(IOUtils.toInputStream((String)xml, (Charset)Charset.defaultCharset())));
        }
        catch (IOException | SAXException ignored) {
            return false;
        }
        return true;
    }

    public static boolean validateJSON(@NotNull String jsonSchema, @NotNull String json) {
        try {
            JsonSchema schema = JsonSchemaFactory.byDefault().getJsonSchema(JsonLoader.fromString((String)jsonSchema));
            JsonNode jsonToBeValidated = JsonLoader.fromString((String)json);
            return schema.validInstance(jsonToBeValidated);
        }
        catch (ProcessingException | IOException throwable) {
            return false;
        }
    }
}

