/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Service;
import wssimulator.HttpMethod;
import wssimulator.SimulationNotFoundException;
import wssimulator.WSSimulation;
import wssimulator.WSSimulationContext;
import wssimulator.WSSimulatorValidation;
import wssimulator.handler.BaseHandler;

public class WSSimulatorHandlerService {
    private int counter = 0;
    private Map<String, BaseHandler> handlers = new HashMap<String, BaseHandler>();
    private Map<Integer, WSSimulation> validSimulations = new HashMap<Integer, WSSimulation>();
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulatorHandlerService.class);
    private int assignedPort = 0;
    private Map<Integer, Service> simulationServers = new HashMap<Integer, Service>();

    void assignedPort(int port) {
        this.assignedPort = port;
        this.simulationServers.put(port, this.igniteService(port, 10));
    }

    @NotNull
    private Service igniteService(int port, int threads) {
        return Service.ignite().port(port).threadPool(threads);
    }

    public WSSimulationContext add(@NotNull WSSimulation simulation) {
        WSSimulatorValidation.validate(simulation);
        return this.setupRoute(simulation);
    }

    private WSSimulationContext setupRoute(@NotNull WSSimulation simulation) {
        Service simulationServer = this.simulationServers.get(this.assignedPort);
        BaseHandler handler = this.lookupHandler(simulation);
        this.validSimulations.put(++this.counter, simulation);
        simulation.wsSimulationContext.id = this.counter;
        if (handler.routeCount() == 1) {
            switch (simulation.httpMethod) {
                case get: {
                    simulationServer.get(simulation.path, handler::processRequest);
                    LOG.info("GET {} now listening", (Object)simulation.path);
                    break;
                }
                case post: {
                    simulationServer.post(simulation.path, handler::processRequest);
                    LOG.info("POST {} now listening", (Object)simulation.path);
                    break;
                }
                case put: {
                    simulationServer.put(simulation.path, handler::processRequest);
                    LOG.info("PUT {} now listening", (Object)simulation.path);
                    break;
                }
                case patch: {
                    simulationServer.patch(simulation.path, handler::processRequest);
                    LOG.info("PATCH {} now listening", (Object)simulation.path);
                    break;
                }
                case delete: {
                    simulationServer.delete(simulation.path, handler::processRequest);
                    LOG.info("DELETE {} now listening", (Object)simulation.path);
                    break;
                }
                case head: {
                    simulationServer.head(simulation.path, handler::processRequest);
                    LOG.info("HEAD {} now listening", (Object)simulation.path);
                }
            }
        }
        return simulation.wsSimulationContext;
    }

    private BaseHandler lookupHandler(@NotNull WSSimulation wsSimulation) {
        BaseHandler baseHandler = this.handlers.computeIfAbsent(wsSimulation.path + "::" + (Object)((Object)wsSimulation.httpMethod), s -> new BaseHandler());
        baseHandler.addRoute(wsSimulation);
        return baseHandler;
    }

    void shutdownAll() {
        this.simulationServers.forEach((integer, service) -> service.stop());
        this.simulationServers.clear();
        this.validSimulations.clear();
        this.handlers.clear();
        this.counter = 0;
    }

    int validSimulationCount() {
        return this.validSimulations.size();
    }

    @Nullable
    WSSimulation getWSSimulation(int simulationId) {
        WSSimulation wsSimulation = this.validSimulations.get(simulationId);
        if (wsSimulation == null) {
            throw new SimulationNotFoundException(simulationId);
        }
        return wsSimulation;
    }

    public int findSimulationIdByPath(@NotNull String path, @NotNull HttpMethod httpMethod) {
        return this.validSimulations.entrySet().stream().filter(e -> ((WSSimulation)e.getValue()).path.equalsIgnoreCase(path) && ((WSSimulation)e.getValue()).httpMethod.equals((Object)httpMethod)).findFirst().map(Map.Entry::getKey).orElse(-1);
    }

    @NotNull
    Collection<WSSimulation> findSimulationsNamespace(@NotNull String namespace) {
        return this.validSimulations.entrySet().stream().filter(e -> ((WSSimulation)e.getValue()).namespace.startsWith(namespace)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @NotNull
    public Map<Integer, WSSimulation> validSimulations() {
        return this.validSimulations;
    }

    public WSSimulation findSimulationByName(@NotNull String name) {
        return this.getWSSimulation(this.validSimulations.entrySet().stream().filter(e -> name.equalsIgnoreCase(((WSSimulation)e.getValue()).name)).findFirst().map(Map.Entry::getKey).orElse(-1));
    }

    public List<WSSimulation> findSimulationsByPath(String path, HttpMethod httpMethod) {
        return this.validSimulations.entrySet().stream().filter(e -> ((WSSimulation)e.getValue()).path.equalsIgnoreCase(path) && ((WSSimulation)e.getValue()).httpMethod.equals((Object)httpMethod)).map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

