/*
 * Decompiled with CFR 0.152.
 */
package wssimulator.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import wssimulator.scanner.SearchFilter;
import wssimulator.scanner.SimulationContentFilter;
import wssimulator.scanner.SimulationFilter;
import wssimulator.scanner.SimulationFilterType;

public class CompositeFilter
implements SimulationFilter {
    private List<SimulationFilter> filterList = new ArrayList<SimulationFilter>();

    public CompositeFilter(SimulationFilter ... filters) {
        this.checkConflicts(filters);
        this.filterList.addAll(Arrays.asList(filters));
    }

    @NotNull
    public List<SearchFilter> searchFilters() {
        return this.filterList.stream().filter(simulationFilter -> simulationFilter instanceof SearchFilter).map(simulationFilter -> (SearchFilter)simulationFilter).collect(Collectors.toList());
    }

    @NotNull
    public List<SimulationContentFilter> simulationContentFilters() {
        return this.filterList.stream().filter(simulationFilter -> simulationFilter instanceof SimulationContentFilter).map(simulationFilter -> (SimulationContentFilter)simulationFilter).collect(Collectors.toList());
    }

    private void checkConflicts(SimulationFilter[] filters) {
        for (SimulationFilter filter : filters) {
            if (!(filter instanceof CompositeFilter)) continue;
            throw new IllegalStateException("Nested Composite Filters is not allowed");
        }
    }

    @Override
    public SimulationFilterType filterType() {
        return SimulationFilterType.CompositeFilter;
    }
}

