/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wssimulator.WSSimulator;

public class WSSimulationContext {
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulator.class);
    private List<String> messages = new ArrayList<String>();
    private CountDownLatch countDownLatch;
    public int id;

    public void simulationInvoked(String request) {
        this.messages.add(request);
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    public int callCount() {
        return this.messages.size();
    }

    public String lastMessage() {
        return this.messages.size() - 1 >= 0 ? this.messages.get(this.messages.size() - 1) : "";
    }

    public List<String> messages() {
        return this.messages;
    }

    public void blockUntilCalled() {
        this.blockUntilCalled(Integer.MAX_VALUE, TimeUnit.DAYS);
    }

    public void blockUntilCalled(int timeout, TimeUnit timeUnit) {
        try {
            this.countDownLatch = new CountDownLatch(1);
            this.countDownLatch.await(timeout, timeUnit);
            this.countDownLatch = null;
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted", (Throwable)e);
        }
    }
}

