/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wssimulator.HttpMethod;
import wssimulator.WSSimulation;
import wssimulator.WSSimulatorHandlerService;
import wssimulator.YamlNotValidException;

public class Simulator {
    private WSSimulatorHandlerService wsSimulatorHandlerService = new WSSimulatorHandlerService();
    private static final Logger LOG = LoggerFactory.getLogger(Simulator.class);

    public void setPort(int port) {
        Simulator.throwIf(port <= 0 && port > 65535, new RuntimeException(String.format("assignedPort no in bounds bounds (1-65535) %s", port)));
        this.wsSimulatorHandlerService.assignedPort(port);
    }

    @NotNull
    public Simulator addSimulations(Collection<WSSimulation> simulations) {
        simulations.forEach(echoSimulationAsYaml -> {
            try {
                this.wsSimulatorHandlerService.add((WSSimulation)echoSimulationAsYaml);
                LOG.info("loaded YAML Simulation{}", echoSimulationAsYaml);
            }
            catch (YamlNotValidException e) {
                LOG.warn("Failed to load {}", echoSimulationAsYaml);
            }
        });
        return this;
    }

    public int loadedSimulationCount() {
        return this.wsSimulatorHandlerService.validSimulationCount();
    }

    public Collection<WSSimulation> findSimulationsNamespace(@NotNull String namespace) {
        return this.wsSimulatorHandlerService.findSimulationsNamespace(namespace);
    }

    public WSSimulation findSimulation(@NotNull String path, @NotNull HttpMethod httpMethod) {
        int simulationId = this.findSimulationId(path, httpMethod);
        return this.wsSimulatorHandlerService.getWSSimulation(simulationId);
    }

    public int findSimulationId(@NotNull String path, @NotNull HttpMethod httpMethod) {
        return this.wsSimulatorHandlerService.findSimulationIdByPath(path, httpMethod);
    }

    public WSSimulation findSimulationByName(@NotNull String name) {
        return this.wsSimulatorHandlerService.findSimulationByName(name);
    }

    public void shutdown() {
        LOG.info("Shutting down server");
        this.wsSimulatorHandlerService.shutdownAll();
    }

    private static void throwIf(boolean toThrow, RuntimeException toBeThrown) {
        if (toThrow) {
            throw toBeThrown;
        }
    }
}

