/*
 * Decompiled with CFR 0.152.
 */
package wssimulator.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import wssimulator.RouteRequestFilterType;
import wssimulator.WSSimulation;
import wssimulator.WSSimulator;
import wssimulator.handler.ContainsRouteRequestFilterer;
import wssimulator.handler.NoneRouteRequestFilterer;
import wssimulator.handler.RouteRequestFilterer;

public abstract class BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulator.class);
    private Map<RouteRequestFilterType, RouteRequestFilterer> filterTypes = new HashMap<RouteRequestFilterType, RouteRequestFilterer>(){
        {
            this.put(RouteRequestFilterType.none, new NoneRouteRequestFilterer());
            this.put(RouteRequestFilterType.contains, new ContainsRouteRequestFilterer());
        }
    };
    private final List<WSSimulation> wsSimulations = new ArrayList<WSSimulation>();
    private final Random random = new Random();

    public BaseHandler(@NotNull WSSimulation wsSimulations) {
        this.wsSimulations.add(wsSimulations);
    }

    @NotNull
    public final Object processRequest(@NotNull Request request, @NotNull Response response) {
        Map<String, String> params = this.buildParameterValues(request);
        LOG.info("request body:{}", (Object)request.body());
        WSSimulation wsSimulation = this.loadSimulation(request);
        if (wsSimulation != null) {
            ++wsSimulation.wsSimulationContext.callCount;
            if (!this.validate(wsSimulation, request.body())) {
                LOG.info("Validation failed for request, returning status code:{}", (Object)wsSimulation.badRequestResponseCode);
                response.status(wsSimulation.badRequestResponseCode);
                return "";
            }
            if (this.resilienceCheck(wsSimulation)) {
                LOG.info("Resilience Failed, returning status code:{}", (Object)wsSimulation.resilienceFailureCode);
                response.status(wsSimulation.resilienceFailureCode);
                return "";
            }
            if (StringUtils.isNotEmpty((CharSequence)wsSimulation.response)) {
                return new StrSubstitutor(params).replace(wsSimulation.response);
            }
        }
        return "";
    }

    @Nullable
    private WSSimulation loadSimulation(@Nullable Request request) {
        if (this.wsSimulations.size() == 1) {
            return this.wsSimulations.get(0);
        }
        for (WSSimulation wsSimulation : this.wsSimulations) {
            if (!this.filterTypes.get((Object)wsSimulation.request.filterType).filter(wsSimulation, request)) continue;
            return wsSimulation;
        }
        return null;
    }

    private boolean resilienceCheck(@NotNull WSSimulation wsSimulation) {
        return wsSimulation.resilience < 1.0 && wsSimulation.resilience - this.random.nextDouble() <= 0.0;
    }

    protected abstract boolean validate(@NotNull WSSimulation var1, @Nullable String var2);

    private Map<String, String> buildParameterValues(@NotNull Request request) {
        Map<String, String> params = request.params().keySet().stream().collect(Collectors.toMap(p -> String.format("param.%s", p.substring(1)), arg_0 -> ((Request)request).params(arg_0)));
        return params;
    }

    public int routeCount() {
        return this.wsSimulations.size();
    }

    public void addRoute(@NotNull WSSimulation simulation) {
        this.wsSimulations.add(simulation);
    }
}

