/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import wssimulator.WSSimulator;
import wssimulator.WebAppController;
import wssimulator.YamlNotValidException;

public class Bootstrap {
    public static void main(String[] args) {
        Options options = Bootstrap.setupOptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("w")) {
                Bootstrap.webApp(options);
            }
            if (cmd.hasOption("h")) {
                Bootstrap.usage(options);
            }
            if (cmd.hasOption("p")) {
                Bootstrap.setPort(cmd.getOptionValue("p"));
            }
            if (cmd.hasOption("y")) {
                Bootstrap.loadFileOrScan(cmd.getOptionValue("y"));
            }
            if (cmd.hasOption("s")) {
                Bootstrap.printExampleYamlFile();
            }
            if (cmd.getArgList() != null && cmd.getArgList().size() > 0) {
                Bootstrap.loadSimulation(cmd.getArgList());
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            System.exit(1);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Port address not valid");
            System.exit(1);
        }
        catch (IOException | URISyntaxException e) {
            System.err.println("Can't read sample file");
            System.exit(1);
        }
    }

    private static void webApp(Options options) {
        WebAppController webAppController = new WebAppController();
        webAppController.startWebApp();
    }

    private static void printExampleYamlFile() throws URISyntaxException, IOException {
        String sample = IOUtils.toString((InputStream)new FileInputStream(new File(Bootstrap.class.getResource("/example.yml").toURI())), (Charset)Charset.defaultCharset());
        System.out.println(sample);
    }

    private static void loadSimulation(List<String> simulations) {
        for (String simulation : simulations) {
            WSSimulator.addSimulation(simulation);
        }
    }

    private static void loadFileOrScan(String fileOrDirectory) {
        File fileOrDirectoryAsFile = new File(fileOrDirectory);
        if (fileOrDirectoryAsFile.exists() && fileOrDirectoryAsFile.isDirectory()) {
            Collection files = FileUtils.listFiles((File)new File(fileOrDirectory), (String[])new String[]{"yaml"}, (boolean)false);
            WSSimulator.addSimulations(files);
        } else if (fileOrDirectoryAsFile.exists()) {
            WSSimulator.addSimulation(fileOrDirectoryAsFile);
        } else {
            throw new YamlNotValidException("Directory/File could not be found");
        }
    }

    @NotNull
    private static Options setupOptions() {
        Options options = new Options();
        Option help = new Option("h", "print this message");
        Option web = new Option("w", "Starts the web application");
        Option port = new Option("p", true, "Set the HTTP Port to start the server on (1 to 65535)");
        Option fileOrDirectory = new Option("y", true, "Reference to a single yaml simulation file or a directory which will load all *.yml files within the target directory");
        Option sampleYamlFile = new Option("s", false, "Print out an sample YAML Simulation file");
        options.addOption(web);
        options.addOption(help);
        options.addOption(port);
        options.addOption(fileOrDirectory);
        options.addOption(sampleYamlFile);
        return options;
    }

    private static void setPort(String port) {
        WSSimulator.setPort(Integer.valueOf(port));
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("wssimulator [options] \"[optional yaml string]\"", options);
        System.exit(-1);
    }
}

