/*
 * Decompiled with CFR 0.152.
 */
package wssimulator.handler;

import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import wssimulator.WSSimulation;
import wssimulator.WSSimulator;

public abstract class BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulator.class);
    @NotNull
    private final WSSimulation wsSimulation;
    private final Random random = new Random();

    public BaseHandler(@NotNull WSSimulation wsSimulation) {
        this.wsSimulation = wsSimulation;
    }

    @NotNull
    public final Object processRequest(@NotNull Request request, @NotNull Response response) {
        Map<String, String> params = this.buildParameterValues(request);
        LOG.info("request body:{}", (Object)request.body());
        ++this.wsSimulation.wsSimulationContext.callCount;
        if (!this.validate(this.wsSimulation, request.body())) {
            LOG.info("Validation failed for request, returning status code:{}", (Object)this.wsSimulation.badRequestResponseCode);
            response.status(this.wsSimulation.badRequestResponseCode);
            return "";
        }
        if (this.resilienceCheck(this.wsSimulation)) {
            LOG.info("Resilience Failed, returning status code:{}", (Object)this.wsSimulation.resilienceFailureCode);
            response.status(this.wsSimulation.resilienceFailureCode);
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)this.wsSimulation.response)) {
            return new StrSubstitutor(params).replace(this.wsSimulation.response);
        }
        return "";
    }

    private boolean resilienceCheck(@NotNull WSSimulation wsSimulation) {
        return wsSimulation.resilience < 1.0 && wsSimulation.resilience - this.random.nextDouble() <= 0.0;
    }

    protected abstract boolean validate(@NotNull WSSimulation var1, @Nullable String var2);

    private Map<String, String> buildParameterValues(@NotNull Request request) {
        Map<String, String> params = request.params().keySet().stream().collect(Collectors.toMap(p -> String.format("param.%s", p.substring(1)), arg_0 -> ((Request)request).params(arg_0)));
        return params;
    }
}

