/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;
import wssimulator.SimulationNotFoundException;
import wssimulator.WSSimulation;
import wssimulator.WSSimulatorValidation;
import wssimulator.handler.BaseHandler;
import wssimulator.handler.GenericHandler;
import wssimulator.handler.JSONHandler;
import wssimulator.handler.XMLHandler;

public class WSSimulatorServiceManager {
    private int counter = 0;
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulatorServiceManager.class);
    private Map<Integer, WSSimulation> validSimulations = new HashMap<Integer, WSSimulation>();

    private WSSimulatorServiceManager() {
    }

    public List<Integer> getWSSimulationsKeys() {
        return new ArrayList<Integer>(this.validSimulations.keySet());
    }

    @NotNull
    public static WSSimulatorServiceManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @NotNull
    private static WSSimulatorServiceManager startup() {
        return new WSSimulatorServiceManager();
    }

    public int add(@NotNull WSSimulation simulation) {
        WSSimulatorValidation.validate(simulation);
        return this.setupRoute(simulation);
    }

    private int setupRoute(@NotNull WSSimulation simulation) {
        BaseHandler handler = this.handler(simulation);
        this.validSimulations.put(++this.counter, simulation);
        switch (simulation.httpMethod) {
            case get: {
                Spark.get((String)simulation.path, handler::processRequest);
                LOG.info("GET {} now listening", (Object)simulation.path);
                break;
            }
            case post: {
                Spark.post((String)simulation.path, handler::processRequest);
                LOG.info("POST {} now listening", (Object)simulation.path);
                break;
            }
            case put: {
                Spark.put((String)simulation.path, handler::processRequest);
                LOG.info("PUT {} now listening", (Object)simulation.path);
                break;
            }
            case patch: {
                Spark.patch((String)simulation.path, handler::processRequest);
                LOG.info("PATCH {} now listening", (Object)simulation.path);
                break;
            }
            case delete: {
                Spark.delete((String)simulation.path, handler::processRequest);
                LOG.info("DELETE {} now listening", (Object)simulation.path);
                break;
            }
            case head: {
                Spark.head((String)simulation.path, handler::processRequest);
                LOG.info("HEAD {} now listening", (Object)simulation.path);
            }
        }
        return this.counter;
    }

    private BaseHandler handler(@NotNull WSSimulation wsSimulation) {
        if ("application/xml".equals(wsSimulation.consumes)) {
            return new XMLHandler(wsSimulation);
        }
        if ("application/json".equals(wsSimulation.consumes)) {
            return new JSONHandler(wsSimulation);
        }
        return new GenericHandler(wsSimulation);
    }

    public void shutdown() {
        LOG.info("Shutting down server");
        Spark.stop();
        this.validSimulations.clear();
    }

    public int validSimulationCount() {
        return this.validSimulations.size();
    }

    @Nullable
    public WSSimulation getWSSimulation(int simulationId) {
        WSSimulation wsSimulation = this.validSimulations.get(simulationId);
        if (wsSimulation == null) {
            throw new SimulationNotFoundException(simulationId);
        }
        return wsSimulation;
    }

    public int calledCounter(int simulationId) {
        WSSimulation wsSimulation = this.getWSSimulation(simulationId);
        return wsSimulation.wsSimulationContext.callCount;
    }

    public int findSimulationIdByPath(@NotNull String path) {
        return this.validSimulations.entrySet().stream().filter(e -> ((WSSimulation)e.getValue()).path.equalsIgnoreCase(path)).findFirst().map(Map.Entry::getKey).orElse(-1);
    }

    static /* synthetic */ WSSimulatorServiceManager access$000() {
        return WSSimulatorServiceManager.startup();
    }

    private static class SingletonHolder {
        private static final WSSimulatorServiceManager INSTANCE = WSSimulatorServiceManager.access$000();

        private SingletonHolder() {
        }
    }
}

