/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;
import wssimulator.WSSimulation;
import wssimulator.WSSimulatorServiceManager;
import wssimulator.YamlNotValidException;
import wssimulator.YamlToSimulation;

public final class WSSimulator {
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulator.class);
    private static WSSimulatorServiceManager wsSimulatorServiceManager = WSSimulatorServiceManager.getInstance();

    public static void addSimulation(@NotNull String yamlString) {
        YamlToSimulation yamlToSimulation = new YamlToSimulation(yamlString);
        wsSimulatorServiceManager.add(yamlToSimulation.simulatorSimulation());
    }

    public static void addSimulationOnClasspath(@NotNull String classpathLocation) {
        YamlToSimulation yamlToSimulation = new YamlToSimulation(new File(WSSimulator.class.getResource(classpathLocation).getFile()));
        wsSimulatorServiceManager.add(yamlToSimulation.simulatorSimulation());
    }

    public static int addSimulation(@NotNull WSSimulation WSSimulation2) {
        return wsSimulatorServiceManager.add(WSSimulation2);
    }

    public static int addSimulation(@NotNull File echoSimulationAsYaml) {
        YamlToSimulation yamlToSimulation = new YamlToSimulation(echoSimulationAsYaml);
        return WSSimulator.addSimulation(yamlToSimulation.simulatorSimulation());
    }

    public static void shutdown() {
        wsSimulatorServiceManager.shutdown();
    }

    public static void setPort(int port) {
        Spark.port((int)port);
    }

    public static void addSimulations(Collection<File> simulations) {
        simulations.forEach(echoSimulationAsYaml -> {
            try {
                WSSimulator.addSimulation(echoSimulationAsYaml);
                LOG.info("loaded YAML Simulation{}", echoSimulationAsYaml);
            }
            catch (YamlNotValidException e) {
                LOG.warn("Failed to load {}", echoSimulationAsYaml);
            }
        });
    }

    public static int loadedSimulationCount() {
        return wsSimulatorServiceManager.validSimulationCount();
    }

    public static int calledCount(int simulationId) {
        return wsSimulatorServiceManager.calledCounter(simulationId);
    }

    public static int findSimulationIdByPath(@NotNull String path) {
        return wsSimulatorServiceManager.findSimulationIdByPath(path);
    }
}

