/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wssimulator.WSSimulation;
import wssimulator.YamlNotValidException;

public class YamlToSimulation {
    private static final Logger LOG = LoggerFactory.getLogger(YamlToSimulation.class);
    private File yamlFile;
    private String yamlString;

    public YamlToSimulation(@NotNull File yamlFile) {
        this.yamlFile = yamlFile;
    }

    public YamlToSimulation(@NotNull String yamlString) {
        this.yamlString = yamlString;
    }

    @NotNull
    public WSSimulation simulatorSimulation() {
        WSSimulation simulation;
        if (this.yamlFile != null) {
            try {
                this.yamlString = FileUtils.readFileToString((File)this.yamlFile, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                LOG.error(String.format("Could not read yaml file:(%s)", this.yamlFile), (Throwable)e);
                throw new YamlNotValidException("Cannot read file");
            }
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            simulation = (WSSimulation)mapper.readValue(this.yamlString, WSSimulation.class);
        }
        catch (Exception e) {
            LOG.error(String.format("Could not parse yaml file:(%s)", this.yamlFile), (Throwable)e);
            throw new YamlNotValidException(String.format("Could not parse yaml file:(%s)", this.yamlFile));
        }
        return simulation;
    }
}

