/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;
import wssimulator.WSSimulation;
import wssimulator.WSSimulatorValidation;
import wssimulator.handler.BaseHandler;
import wssimulator.handler.GenericHandler;
import wssimulator.handler.JSONHandler;
import wssimulator.handler.XMLHandler;

public class WSSimulatorServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulatorServiceManager.class);
    private List<WSSimulation> validSimulations = new ArrayList<WSSimulation>();

    public void add(@NotNull WSSimulation simulation) {
        WSSimulatorValidation.validate(simulation);
        this.setupRoute(simulation);
    }

    private void setupRoute(@NotNull WSSimulation simulation) {
        BaseHandler handler = this.handler(simulation);
        this.validSimulations.add(simulation);
        switch (simulation.httpMethod) {
            case get: {
                Spark.get((String)simulation.path, handler::processRequest);
                LOG.info("GET {} now listening", (Object)simulation.path);
                break;
            }
            case post: {
                Spark.post((String)simulation.path, handler::processRequest);
                LOG.info("POST {} now listening", (Object)simulation.path);
                break;
            }
            case put: {
                Spark.put((String)simulation.path, handler::processRequest);
                LOG.info("PUT {} now listening", (Object)simulation.path);
                break;
            }
            case patch: {
                Spark.patch((String)simulation.path, handler::processRequest);
                LOG.info("PATCH {} now listening", (Object)simulation.path);
                break;
            }
            case delete: {
                Spark.delete((String)simulation.path, handler::processRequest);
                LOG.info("DELETE {} now listening", (Object)simulation.path);
                break;
            }
            case head: {
                Spark.head((String)simulation.path, handler::processRequest);
                LOG.info("HEAD {} now listening", (Object)simulation.path);
            }
        }
    }

    private BaseHandler handler(@NotNull WSSimulation wsSimulation) {
        if ("application/xml".equals(wsSimulation.consumes)) {
            return new XMLHandler(wsSimulation);
        }
        if ("application/json".equals(wsSimulation.consumes)) {
            return new JSONHandler(wsSimulation);
        }
        return new GenericHandler(wsSimulation);
    }

    public void shutdown() {
        LOG.info("Shutting down server");
        Spark.stop();
        this.validSimulations.clear();
    }

    public int validSimulationCount() {
        return this.validSimulations.size();
    }
}

