/*
 * Decompiled with CFR 0.152.
 */
package wssimulator.handler;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spark.Request;
import spark.Response;
import wssimulator.WSSimulation;

public abstract class BaseHandler {
    @NotNull
    private final WSSimulation wsSimulation;

    public BaseHandler(@NotNull WSSimulation wsSimulation) {
        this.wsSimulation = wsSimulation;
    }

    @NotNull
    public final Object processRequest(@NotNull Request request, @NotNull Response response) {
        Map<String, String> params = this.buildParameterValues(request);
        if (!this.validate(this.wsSimulation, request.body())) {
            response.status(this.wsSimulation.badRequestResponseCode);
            return "";
        }
        response.status(this.wsSimulation.successResponseCode);
        if (StringUtils.isNotEmpty((CharSequence)this.wsSimulation.response)) {
            return new StrSubstitutor(params).replace(this.wsSimulation.response);
        }
        return "";
    }

    protected abstract boolean validate(@NotNull WSSimulation var1, @Nullable String var2);

    private Map<String, String> buildParameterValues(Request request) {
        Map<String, String> params = request.params().keySet().stream().collect(Collectors.toMap(p -> String.format("param.%s", p.substring(1)), arg_0 -> ((Request)request).params(arg_0)));
        return params;
    }
}

