/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;
import wssimulator.HttpMethod;
import wssimulator.WSSimulation;
import wssimulator.WSSimulationContext;
import wssimulator.WSSimulatorServiceManager;
import wssimulator.YamlNotValidException;
import wssimulator.YamlToSimulation;

public final class WSSimulator {
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulator.class);
    private static WSSimulatorServiceManager wsSimulatorServiceManager = WSSimulatorServiceManager.getInstance();

    public static void addSimulation(@NotNull String yamlString) {
        LOG.info("adding simulation string: {}", (Object)yamlString);
        YamlToSimulation yamlToSimulation = new YamlToSimulation(yamlString);
        wsSimulatorServiceManager.add(yamlToSimulation.simulatorSimulation());
    }

    public static void addSimulationOnClasspath(@NotNull String classpathLocation) {
        LOG.info("adding simulation on classpath: {}", (Object)classpathLocation);
        YamlToSimulation yamlToSimulation = new YamlToSimulation(new File(WSSimulator.class.getResource(classpathLocation).getFile()));
        wsSimulatorServiceManager.add(yamlToSimulation.simulatorSimulation());
    }

    public static WSSimulationContext addSimulation(@NotNull WSSimulation WSSimulation2) {
        return wsSimulatorServiceManager.add(WSSimulation2);
    }

    public static WSSimulationContext addSimulation(@NotNull File echoSimulationAsYaml) {
        LOG.info("adding simulation file: {}", (Object)echoSimulationAsYaml);
        YamlToSimulation yamlToSimulation = new YamlToSimulation(echoSimulationAsYaml);
        return WSSimulator.addSimulation(yamlToSimulation.simulatorSimulation());
    }

    public static void shutdown() {
        LOG.info("Shutting down server");
        wsSimulatorServiceManager.shutdown();
    }

    public static void setPort(int port) {
        LOG.info("setting port to {}", (Object)port);
        Spark.port((int)port);
    }

    public static void addSimulations(Collection<File> simulations) {
        simulations.forEach(echoSimulationAsYaml -> {
            try {
                WSSimulator.addSimulation(echoSimulationAsYaml);
                LOG.info("loaded YAML Simulation{}", echoSimulationAsYaml);
            }
            catch (YamlNotValidException e) {
                LOG.warn("Failed to load {}", echoSimulationAsYaml);
            }
        });
    }

    public static int loadedSimulationCount() {
        return wsSimulatorServiceManager.validSimulationCount();
    }

    public static int calledCount(int simulationId) {
        return wsSimulatorServiceManager.calledCounter(simulationId);
    }

    public static String lastRequest(int simulationId) {
        return wsSimulatorServiceManager.lastRequest(simulationId);
    }

    public static int findSimulationId(@NotNull String path, @NotNull HttpMethod httpMethod) {
        int simulationIdByPath = wsSimulatorServiceManager.findSimulationIdByPath(path, httpMethod);
        return simulationIdByPath;
    }

    public static WSSimulation findSimulation(@NotNull String path, @NotNull HttpMethod httpMethod) {
        int simulationId = WSSimulator.findSimulationId(path, httpMethod);
        return wsSimulatorServiceManager.getWSSimulation(simulationId);
    }
}

