/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Route;
import wssimulator.HttpMethod;
import wssimulator.WSSimulation;
import wssimulator.WSSimulatorServiceManager;

public class WebAppController
implements Route {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppController.class);
    private String baseRoute = "/wssimulator";
    private String route = this.baseRoute + "/:simulation";

    public Object handle(Request request, Response response) throws Exception {
        String simulationId = request.params("simulation");
        LOG.info("Simulation {} received for {}", (Object)simulationId, (Object)request.requestMethod());
        switch (HttpMethod.valueOf(request.requestMethod().toLowerCase())) {
            case get: {
                return this.getSimulations(simulationId, request, response);
            }
            case post: {
                throw new IllegalArgumentException("Not Implemented");
            }
            case put: {
                return this.putSimulation(request, response);
            }
            case patch: {
                return this.patchSimulation(simulationId, request, response);
            }
            case delete: {
                return this.deleteSimulation(simulationId, request, response);
            }
            case head: {
                throw new IllegalArgumentException("Not Implemented");
            }
        }
        throw new IllegalArgumentException("Not Implemented");
    }

    @NotNull
    private Object putSimulation(@NotNull Request request, @NotNull Response response) {
        return this.noOpCreated(response);
    }

    @NotNull
    private Object deleteSimulation(@NotNull String simulationId, @NotNull Request request, @NotNull Response response) {
        return null;
    }

    @NotNull
    private Object getSimulations(@Nullable String simulationId, @NotNull Request request, @NotNull Response response) {
        if (StringUtils.isEmpty((CharSequence)simulationId)) {
            return WSSimulatorServiceManager.getInstance().getWSSimulationsKeys();
        }
        return this.toYaml(WSSimulatorServiceManager.getInstance().getWSSimulation(Integer.valueOf(simulationId)));
    }

    @NotNull
    private String toYaml(@Nullable WSSimulation wsSimulation) {
        return "";
    }

    private String patchSimulation(@NotNull String simulationId, @NotNull Request request, @NotNull Response response) {
        return this.noOpCreated(response);
    }

    @NotNull
    private String noOpCreated(@NotNull Response response) {
        response.status(201);
        return "";
    }
}

