/*
 * Decompiled with CFR 0.152.
 */
package wssimulator;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wssimulator.WSSimulator;

public class WSSimulationContext {
    private static final Logger LOG = LoggerFactory.getLogger(WSSimulator.class);
    private int callCount;
    private String lastMessage;
    private CountDownLatch countDownLatch;

    public void simulationInvoked(String request) {
        ++this.callCount;
        this.lastMessage = request;
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    public int callCount() {
        return this.callCount;
    }

    public String lastMessage() {
        return this.lastMessage;
    }

    public void blockUntilCalled() {
        this.blockUntilCalled(Integer.MAX_VALUE, TimeUnit.DAYS);
    }

    public void blockUntilCalled(int timeout, TimeUnit timeUnit) {
        try {
            this.countDownLatch = new CountDownLatch(1);
            this.countDownLatch.await(timeout, timeUnit);
            this.countDownLatch = null;
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted", (Throwable)e);
        }
    }
}

