package co.tomlee.nifty;

import java.net.InetSocketAddress;
import java.time.Duration;

/**
 * Base interface for Thrift client proxy factory.
 *
 * @param <T>    Thrift interface type
 */
public interface ThriftClientProxyFactory<T> {
    /**
     * Creates a new proxy for the given socket address.
     *
     * @param socketAddress    the remote address
     * @return a new proxy
     * @throws Exception
     */
    T newProxy(InetSocketAddress socketAddress) throws Exception;

    /**
     * Creates a new proxy for the given socket address, with a borrow timeout.
     *
     * @param socketAddress    the remote address
     * @param timeout          the borrow timeout
     * @return a new proxy
     * @throws Exception
     */
    T newProxy(InetSocketAddress socketAddress, Duration timeout) throws Exception;
}
