/*
 * Decompiled with CFR 0.152.
 */
package co.tomlee.nifty;

import co.tomlee.nifty.TNiftyClientTransportValidator;
import com.facebook.nifty.client.NettyClientConfig;
import com.facebook.nifty.client.NettyClientConfigBuilder;
import com.facebook.nifty.client.NiftyClient;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public final class TNiftyClientChannelTransportPoolConfig {
    final NiftyClient niftyClient;
    final Class<? extends TServiceClient> clientClass;
    GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
    int maxFrameSize = 0x100000;
    Duration connectTimeout = new Duration(5.0, TimeUnit.SECONDS);
    Duration readTimeout = new Duration(5.0, TimeUnit.SECONDS);
    Duration receiveTimeout = new Duration(5.0, TimeUnit.SECONDS);
    Duration sendTimeout = new Duration(5.0, TimeUnit.SECONDS);
    TProtocolFactory protocolFactory = new TCompactProtocol.Factory(this.maxFrameSize);
    TNiftyClientTransportValidator checkTransport;

    public TNiftyClientChannelTransportPoolConfig(Class<? extends TServiceClient> clientClass) {
        this(new NettyClientConfigBuilder().build(), clientClass);
    }

    public TNiftyClientChannelTransportPoolConfig(int bossThreads, int workerThreads, Class<? extends TServiceClient> clientClass) {
        this(((NettyClientConfigBuilder)((NettyClientConfigBuilder)new NettyClientConfigBuilder().setWorkerThreadCount(workerThreads)).setBossThreadCount(bossThreads)).build(), clientClass);
    }

    public TNiftyClientChannelTransportPoolConfig(NettyClientConfig nettyClientConfig, Class<? extends TServiceClient> clientClass) {
        this(new NiftyClient(nettyClientConfig), clientClass);
    }

    public TNiftyClientChannelTransportPoolConfig(NiftyClient niftyClient, Class<? extends TServiceClient> clientClass) {
        this.niftyClient = niftyClient;
        this.clientClass = clientClass;
        this.poolConfig.setMaxTotal(512);
        this.poolConfig.setMaxTotalPerKey(8);
        this.poolConfig.setMaxIdlePerKey(6);
        this.poolConfig.setMinIdlePerKey(2);
        this.poolConfig.setBlockWhenExhausted(true);
        this.poolConfig.setLifo(false);
    }

    void validate() {
        Preconditions.checkNotNull((Object)this.niftyClient);
        Preconditions.checkNotNull(this.clientClass);
    }

    public TNiftyClientChannelTransportPoolConfig connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = new Duration((double)connectTimeout, timeUnit);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig receiveTimeout(int receiveTimeout, TimeUnit timeUnit) {
        this.receiveTimeout = new Duration((double)receiveTimeout, timeUnit);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig readTimeout(int readTimeout, TimeUnit timeUnit) {
        this.readTimeout = new Duration((double)readTimeout, timeUnit);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig sendTimeout(int sendTimeout, TimeUnit timeUnit) {
        this.sendTimeout = new Duration((double)sendTimeout, timeUnit);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig maxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig protocolFactory(TProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig maxTotalConnections(int maxTotalConnections) {
        this.poolConfig.setMaxTotal(maxTotalConnections);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig maxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
        this.poolConfig.setMaxTotalPerKey(maxConnectionsPerEndpoint);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig maxIdlePerEndpoint(int maxIdlePerEndpoint) {
        this.poolConfig.setMaxIdlePerKey(maxIdlePerEndpoint);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig minIdlePerEndpoint(int minIdlePerEndpoint) {
        this.poolConfig.setMinIdlePerKey(minIdlePerEndpoint);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig blockWhenExhausted(boolean blockWhenExhausted) {
        this.poolConfig.setBlockWhenExhausted(blockWhenExhausted);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig maxWaitTime(int maxWaitTime, TimeUnit maxWaitUnit) {
        this.poolConfig.setMaxWaitMillis(maxWaitUnit.toMillis(maxWaitTime));
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig validateOnBorrow(boolean validateOnBorrow) {
        this.poolConfig.setTestOnBorrow(validateOnBorrow);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig validateOnReturn(boolean validateOnReturn) {
        this.poolConfig.setTestOnReturn(validateOnReturn);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig validateWhileIdle(boolean validateWhileIdle) {
        this.poolConfig.setTestWhileIdle(validateWhileIdle);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig minEvictableIdleTime(int time, TimeUnit timeUnit) {
        this.poolConfig.setMinEvictableIdleTimeMillis(timeUnit.toMillis(time));
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig timeBetweenEvictionRuns(int time, TimeUnit timeUnit) {
        this.poolConfig.setTimeBetweenEvictionRunsMillis(timeUnit.toMillis(time));
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig numTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.poolConfig.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig enableJmx() {
        this.poolConfig.setJmxEnabled(true);
        return this;
    }

    public TNiftyClientChannelTransportPoolConfig lifo(boolean lifo) {
        this.poolConfig.setLifo(lifo);
        return this;
    }
}

