/*
 * Decompiled with CFR 0.152.
 */
package co.tomlee.nifty;

import co.tomlee.nifty.TNiftyClientChannelTransportPool;
import co.tomlee.nifty.ThriftClientProxyFactory;
import com.google.common.net.HostAndPort;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public final class PoolingThriftClientProxyFactory<U>
implements ThriftClientProxyFactory<U> {
    private final TNiftyClientChannelTransportPool connectionPool;
    private final Constructor<U> proxyConstructor;

    public PoolingThriftClientProxyFactory(TNiftyClientChannelTransportPool connectionPool, Class<U> serviceInterface) {
        this.connectionPool = connectionPool;
        Class<?> proxyClass = Proxy.getProxyClass(this.getClass().getClassLoader(), serviceInterface);
        try {
            this.proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public U newProxy(String host, int port) throws Exception {
        return this.newProxy(new InetSocketAddress(host, port));
    }

    public U newProxy(HostAndPort hostAndPort) throws Exception {
        return this.newProxy(new InetSocketAddress(hostAndPort.getHostText(), hostAndPort.getPort()));
    }

    @Override
    public U newProxy(InetSocketAddress address) throws Exception {
        return this.proxyConstructor.newInstance(this.newInvocationHandler(address, null));
    }

    public U newProxy(String host, int port, Duration timeout) throws Exception {
        InetSocketAddress address = new InetSocketAddress(host, port);
        return this.newProxy(address, timeout);
    }

    public U newProxy(HostAndPort hostAndPort, Duration timeout) throws Exception {
        InetSocketAddress address = new InetSocketAddress(hostAndPort.getHostText(), hostAndPort.getPort());
        return this.newProxy(address, timeout);
    }

    @Override
    public U newProxy(InetSocketAddress address, Duration timeout) throws Exception {
        return this.proxyConstructor.newInstance(this.newInvocationHandler(address, timeout));
    }

    private U makeClient(TProtocol protocol) throws Exception {
        return (U)this.connectionPool.clientConstructor().newInstance(protocol);
    }

    private InvocationHandler newInvocationHandler(InetSocketAddress address, Duration timeout) {
        return (proxy, method, args) -> {
            try (TTransport transport = timeout == null ? this.connectionPool.getTransport(address) : this.connectionPool.getTransport(address, timeout);){
                TProtocol protocol = this.connectionPool.protocolFactory().getProtocol(transport);
                U client = this.makeClient(protocol);
                Object object = method.invoke(client, args);
                return object;
            }
        };
    }
}

