/*
 * Decompiled with CFR 0.152.
 */
package co.tomlee.nifty;

import co.tomlee.nifty.TNiftyClientTransportValidator;
import com.facebook.nifty.client.NettyClientConfig;
import com.facebook.nifty.client.NettyClientConfigBuilder;
import com.facebook.nifty.client.NiftyClient;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public final class ThriftClientConnectionPoolConfig<T extends TServiceClient, U> {
    final NiftyClient niftyClient;
    final Class<T> clientClass;
    final Class<U> serviceInterface;
    GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
    int maxFrameSize = 0x100000;
    Duration connectTimeout = new Duration(5.0, TimeUnit.SECONDS);
    Duration readTimeout = new Duration(5.0, TimeUnit.SECONDS);
    Duration receiveTimeout = new Duration(5.0, TimeUnit.SECONDS);
    Duration sendTimeout = new Duration(5.0, TimeUnit.SECONDS);
    TProtocolFactory protocolFactory = new TCompactProtocol.Factory(this.maxFrameSize);
    TNiftyClientTransportValidator checkTransport;

    public ThriftClientConnectionPoolConfig(Class<T> clientClass, Class<U> serviceInterface) {
        this(new NettyClientConfigBuilder().build(), clientClass, serviceInterface);
    }

    public ThriftClientConnectionPoolConfig(int bossThreads, int workerThreads, Class<T> clientClass, Class<U> serviceInterface) {
        this(((NettyClientConfigBuilder)((NettyClientConfigBuilder)new NettyClientConfigBuilder().setWorkerThreadCount(workerThreads)).setBossThreadCount(bossThreads)).build(), clientClass, serviceInterface);
    }

    public ThriftClientConnectionPoolConfig(NettyClientConfig nettyClientConfig, Class<T> clientClass, Class<U> serviceInterface) {
        this(new NiftyClient(nettyClientConfig), clientClass, serviceInterface);
    }

    public ThriftClientConnectionPoolConfig(NiftyClient niftyClient, Class<T> clientClass, Class<U> serviceInterface) {
        this.niftyClient = niftyClient;
        this.clientClass = clientClass;
        this.serviceInterface = serviceInterface;
        this.poolConfig.setMaxTotal(512);
        this.poolConfig.setMaxTotalPerKey(8);
        this.poolConfig.setMaxIdlePerKey(6);
        this.poolConfig.setMinIdlePerKey(2);
        this.poolConfig.setBlockWhenExhausted(true);
        this.poolConfig.setLifo(false);
    }

    void validate() {
        Preconditions.checkNotNull((Object)this.niftyClient);
        Preconditions.checkNotNull(this.clientClass);
        Preconditions.checkNotNull(this.serviceInterface);
    }

    public ThriftClientConnectionPoolConfig<T, U> connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = new Duration((double)connectTimeout, timeUnit);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> receiveTimeout(int receiveTimeout, TimeUnit timeUnit) {
        this.receiveTimeout = new Duration((double)receiveTimeout, timeUnit);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> readTimeout(int readTimeout, TimeUnit timeUnit) {
        this.readTimeout = new Duration((double)readTimeout, timeUnit);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> sendTimeout(int sendTimeout, TimeUnit timeUnit) {
        this.sendTimeout = new Duration((double)sendTimeout, timeUnit);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> maxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> protocolFactory(TProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> maxTotalConnections(int maxTotalConnections) {
        this.poolConfig.setMaxTotal(maxTotalConnections);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> maxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
        this.poolConfig.setMaxTotalPerKey(maxConnectionsPerEndpoint);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> maxIdlePerEndpoint(int maxIdlePerEndpoint) {
        this.poolConfig.setMaxIdlePerKey(maxIdlePerEndpoint);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> minIdlePerEndpoint(int minIdlePerEndpoint) {
        this.poolConfig.setMinIdlePerKey(minIdlePerEndpoint);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> blockWhenExhausted(boolean blockWhenExhausted) {
        this.poolConfig.setBlockWhenExhausted(blockWhenExhausted);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> maxWaitTime(int maxWaitTime, TimeUnit maxWaitUnit) {
        this.poolConfig.setMaxWaitMillis(maxWaitUnit.toMillis(maxWaitTime));
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> validateOnBorrow(boolean validateOnBorrow) {
        this.poolConfig.setTestOnBorrow(validateOnBorrow);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> validateOnReturn(boolean validateOnReturn) {
        this.poolConfig.setTestOnReturn(validateOnReturn);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> validateWhileIdle(boolean validateWhileIdle) {
        this.poolConfig.setTestWhileIdle(validateWhileIdle);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> minEvictableIdleTime(int time, TimeUnit timeUnit) {
        this.poolConfig.setMinEvictableIdleTimeMillis(timeUnit.toMillis(time));
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> timeBetweenEvictionRuns(int time, TimeUnit timeUnit) {
        this.poolConfig.setTimeBetweenEvictionRunsMillis(timeUnit.toMillis(time));
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> numTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.poolConfig.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> enableJmx() {
        this.poolConfig.setJmxEnabled(true);
        return this;
    }

    public ThriftClientConnectionPoolConfig<T, U> lifo(boolean lifo) {
        this.poolConfig.setLifo(lifo);
        return this;
    }
}

