/*
 * Decompiled with CFR 0.152.
 */
package co.tomlee.nifty;

import co.tomlee.nifty.ThriftClientConnectionPoolConfig;
import com.facebook.nifty.client.FramedClientConnector;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.client.TNiftyClientChannelTransport;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThriftClientConnectionPool<U>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ThriftClientConnectionPool.class);
    private final GenericKeyedObjectPool<InetSocketAddress, TNiftyClientChannelTransport> pool;
    private final Class<U> serviceInterface;
    private final TProtocolFactory protocolFactory;

    public ThriftClientConnectionPool(final ThriftClientConnectionPoolConfig<?, U> config) {
        config.validate();
        this.serviceInterface = config.serviceInterface;
        this.protocolFactory = config.protocolFactory;
        final TDuplexProtocolFactory duplexProtocolFactory = TDuplexProtocolFactory.fromSingleFactory((TProtocolFactory)config.protocolFactory);
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new BaseKeyedPooledObjectFactory<InetSocketAddress, TNiftyClientChannelTransport>(){

            public TNiftyClientChannelTransport create(InetSocketAddress key) throws Exception {
                log.debug("Connecting to {}", (Object)key);
                FramedClientConnector connector = new FramedClientConnector(key, duplexProtocolFactory);
                TNiftyClientChannelTransport transport = config.niftyClient.connectSync(config.clientClass, (NiftyClientConnector)connector, config.connectTimeout, config.receiveTimeout, config.readTimeout, config.sendTimeout, config.maxFrameSize);
                log.debug("Connected to {}", (Object)key);
                return transport;
            }

            public PooledObject<TNiftyClientChannelTransport> wrap(TNiftyClientChannelTransport value) {
                return new DefaultPooledObject((Object)value);
            }

            public boolean validateObject(InetSocketAddress key, PooledObject<TNiftyClientChannelTransport> p) {
                if (config.checkTransport != null) {
                    log.debug("Validating connection to {}", (Object)key);
                    return config.checkTransport.validate((TNiftyClientChannelTransport)p.getObject());
                }
                return true;
            }

            public void destroyObject(InetSocketAddress key, PooledObject<TNiftyClientChannelTransport> p) throws Exception {
                log.debug("Closing connection to " + key);
                ((TNiftyClientChannelTransport)p.getObject()).close();
            }
        }, config.poolConfig);
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public TTransport getTransport(String host, int port) throws Exception {
        return this.getTransport(InetSocketAddress.createUnresolved(host, port));
    }

    public TTransport getTransport(HostAndPort hostAndPort) throws Exception {
        return this.getTransport(InetSocketAddress.createUnresolved(hostAndPort.getHostText(), hostAndPort.getPort()));
    }

    public TTransport getTransport(HostAndPort hostAndPort, Duration timeout) throws Exception {
        return this.getTransport(InetSocketAddress.createUnresolved(hostAndPort.getHostText(), hostAndPort.getPort()), timeout);
    }

    public TTransport getTransport(InetSocketAddress socketAddress) throws Exception {
        TNiftyClientChannelTransport transport = (TNiftyClientChannelTransport)this.pool.borrowObject((Object)socketAddress);
        return new TTransportShell(socketAddress, transport);
    }

    public TTransport getTransport(InetSocketAddress socketAddress, Duration timeout) throws Exception {
        TNiftyClientChannelTransport transport = (TNiftyClientChannelTransport)this.pool.borrowObject((Object)socketAddress, timeout.toMillis());
        return new TTransportShell(socketAddress, transport);
    }

    TProtocolFactory protocolFactory() {
        return this.protocolFactory;
    }

    Class<U> serviceInterface() {
        return this.serviceInterface;
    }

    private final class TTransportShell
    extends TTransport {
        private final InetSocketAddress socketAddress;
        private final TNiftyClientChannelTransport transport;

        public TTransportShell(InetSocketAddress socketAddress, TNiftyClientChannelTransport transport) {
            this.socketAddress = socketAddress;
            this.transport = transport;
        }

        public boolean isOpen() {
            return this.transport.isOpen();
        }

        public void open() throws TTransportException {
            this.transport.open();
        }

        public void close() {
            ThriftClientConnectionPool.this.pool.returnObject((Object)this.socketAddress, (Object)this.transport);
        }

        public int read(byte[] bytes, int offset, int size) throws TTransportException {
            log.debug("Waiting to receive up to {} bytes from {}", (Object)size, (Object)this.socketAddress);
            int bytesRead = this.transport.read(bytes, offset, size);
            log.debug("Received {} bytes from {}", (Object)bytesRead, (Object)this.socketAddress);
            return bytesRead;
        }

        public void write(byte[] bytes, int offset, int size) throws TTransportException {
            log.debug("Writing {} bytes to {}", (Object)size, (Object)this.socketAddress);
            this.transport.write(bytes, offset, size);
        }

        public void flush() throws TTransportException {
            log.debug("Flushing write buffer to {}", (Object)this.socketAddress);
            this.transport.flush();
        }

        public boolean peek() {
            return this.transport.peek();
        }

        public int readAll(byte[] buf, int off, int len) throws TTransportException {
            log.debug("Waiting to receive all {} bytes from {}", (Object)len, (Object)this.socketAddress);
            return this.transport.readAll(buf, off, len);
        }

        public void write(byte[] buf) throws TTransportException {
            log.debug("Writing {} bytes to {}", (Object)buf.length, (Object)this.socketAddress);
            this.transport.write(buf);
        }

        public byte[] getBuffer() {
            return this.transport.getBuffer();
        }

        public int getBufferPosition() {
            return this.transport.getBufferPosition();
        }

        public int getBytesRemainingInBuffer() {
            return this.transport.getBytesRemainingInBuffer();
        }

        public void consumeBuffer(int len) {
            this.transport.consumeBuffer(len);
        }
    }
}

