/*
 * Decompiled with CFR 0.152.
 */
package co.tomlee.nifty;

import co.tomlee.nifty.ThriftClientConnectionPool;
import co.tomlee.nifty.ThriftClientProxyFactory;
import com.google.common.net.HostAndPort;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public final class PooledThriftClientProxyFactory<T extends TServiceClient, U>
implements ThriftClientProxyFactory<U> {
    private final ThriftClientConnectionPool<U> connectionPool;
    private final Constructor<U> proxyConstructor;
    private final TServiceClientFactory<T> clientFactory;

    public PooledThriftClientProxyFactory(ThriftClientConnectionPool<U> connectionPool, TServiceClientFactory<T> clientFactory) {
        this.connectionPool = connectionPool;
        this.clientFactory = clientFactory;
        Class<?> proxyClass = Proxy.getProxyClass(this.getClass().getClassLoader(), connectionPool.serviceInterface());
        try {
            this.proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public U newProxy(String host, int port) throws Exception {
        return this.newProxy(new InetSocketAddress(host, port));
    }

    public U newProxy(HostAndPort hostAndPort) throws Exception {
        return this.newProxy(new InetSocketAddress(hostAndPort.getHostText(), hostAndPort.getPort()));
    }

    @Override
    public U newProxy(InetSocketAddress address) throws Exception {
        return this.proxyConstructor.newInstance(this.newInvocationHandler(address, null));
    }

    public U newProxy(String host, int port, Duration timeout) throws Exception {
        InetSocketAddress address = new InetSocketAddress(host, port);
        return this.newProxy(address, timeout);
    }

    public U newProxy(HostAndPort hostAndPort, Duration timeout) throws Exception {
        InetSocketAddress address = new InetSocketAddress(hostAndPort.getHostText(), hostAndPort.getPort());
        return this.newProxy(address, timeout);
    }

    @Override
    public U newProxy(InetSocketAddress address, Duration timeout) throws Exception {
        return this.proxyConstructor.newInstance(this.newInvocationHandler(address, timeout));
    }

    private InvocationHandler newInvocationHandler(InetSocketAddress address, Duration timeout) {
        return (proxy, method, args) -> {
            try (TTransport transport = timeout == null ? this.connectionPool.getTransport(address) : this.connectionPool.getTransport(address, timeout);){
                TProtocol protocol = this.connectionPool.protocolFactory().getProtocol(transport);
                TServiceClient client = this.clientFactory.getClient(protocol);
                Object object = method.invoke((Object)client, args);
                return object;
            }
        };
    }
}

