/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.remote.galaxy;

import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.galaxy.Cache;
import co.paralleluniverse.galaxy.CacheListener;
import co.paralleluniverse.galaxy.quasar.Grid;
import co.paralleluniverse.galaxy.quasar.Store;
import co.paralleluniverse.io.serialization.Serialization;
import co.paralleluniverse.remote.galaxy.GlxRemoteChannel;
import co.paralleluniverse.strands.channels.SendPort;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalRemoteChannelReceiver<Message>
implements CacheListener {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalRemoteChannelReceiver.class);
    private static final Store store;
    private final SendPort<Message> channel;
    private final long ref;
    private volatile MessageFilter<Message> filter;

    public static <Message> GlobalRemoteChannelReceiver<Message> getReceiver(SendPort<Message> channel, long ref) {
        return (GlobalRemoteChannelReceiver)store.setListenerIfAbsent(ref, new GlobalRemoteChannelReceiver<Message>(channel, ref));
    }

    public static void stopReceiver(long ref) {
        store.setListener(ref, null);
    }

    private GlobalRemoteChannelReceiver(SendPort<Message> channel, long ref) {
        this.channel = channel;
        this.ref = ref;
    }

    public void setFilter(MessageFilter<Message> filter) {
        this.filter = filter;
    }

    public void invalidated(Cache cache, long id) {
    }

    public void received(Cache cache, long id, long version, ByteBuffer data) {
    }

    public void evicted(Cache cache, long id) {
    }

    public void killed(Cache cache, long id) {
    }

    public void messageReceived(byte[] message) {
        Object m1 = Serialization.getInstance().read(message);
        LOG.debug("Received: {} -> {}", m1, this.channel);
        if (m1 instanceof GlxRemoteChannel.CloseMessage) {
            Throwable t = ((GlxRemoteChannel.CloseMessage)m1).getException();
            if (t != null) {
                this.channel.close(t);
            } else {
                this.channel.close();
            }
            this.unsubscribe();
            return;
        }
        if (m1 instanceof GlxRemoteChannel.RefMessage) {
            return;
        }
        Object m = m1;
        if (this.filter == null || this.filter.shouldForwardMessage(m)) {
            try {
                this.channel.send(m);
            }
            catch (SuspendExecution e) {
                throw new AssertionError((Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void unsubscribe() {
        store.setListener(this.ref, null);
    }

    static {
        try {
            store = Grid.getInstance().store();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface MessageFilter<Message> {
        public boolean shouldForwardMessage(Message var1);
    }
}

