/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.BasicActor;
import co.paralleluniverse.actors.ExitMessage;
import co.paralleluniverse.actors.LifecycleMessage;
import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.HttpResponse;
import co.paralleluniverse.comsat.webactors.HttpStreamOpened;
import co.paralleluniverse.comsat.webactors.SSE;
import co.paralleluniverse.comsat.webactors.WebDataMessage;
import co.paralleluniverse.comsat.webactors.WebMessage;
import co.paralleluniverse.comsat.webactors.WebStreamOpened;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.channels.Channels;
import co.paralleluniverse.strands.channels.SendPort;
import com.google.common.base.Function;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MyWebActor
extends BasicActor<WebMessage, Void> {
    private static final Set<ActorRef<WebMessage>> actors = Collections.newSetFromMap(new ConcurrentHashMap());
    private SendPort<WebDataMessage> peer;

    protected final Void doRun() throws InterruptedException, SuspendExecution {
        actors.add((ActorRef<WebMessage>)this.self());
        try {
            while (true) {
                HttpRequest msg;
                Object message;
                if ((message = this.receive()) instanceof HttpRequest) {
                    msg = (HttpRequest)message;
                    switch (msg.getRequestURI()) {
                        case "/": {
                            msg.getFrom().send((Object)HttpResponse.ok((ActorRef)this.self(), (HttpRequest)msg, (String)"httpResponse").setContentType("text/html").build());
                            break;
                        }
                        case "/notfound": {
                            msg.getFrom().send((Object)HttpResponse.error((ActorRef)this.self(), (HttpRequest)msg, (int)404, (String)"Not found").setContentType("text/plain").build());
                            break;
                        }
                        case "/die": {
                            throw new RuntimeException("die");
                        }
                        case "/redirect": {
                            msg.getFrom().send((Object)HttpResponse.redirect((HttpRequest)msg, (String)"/foo").build());
                            break;
                        }
                        case "/ssepublish": {
                            this.postMessage(new WebDataMessage(this.self(), msg.getStringBody()));
                            msg.getFrom().send((Object)HttpResponse.ok((ActorRef)this.self(), (HttpRequest)msg, (String)"").build());
                            break;
                        }
                        case "/ssechannel": {
                            msg.getFrom().send((Object)SSE.startSSE((ActorRef)this.self(), (HttpRequest)msg).build());
                        }
                    }
                    continue;
                }
                if (message instanceof WebStreamOpened) {
                    msg = (WebStreamOpened)message;
                    this.watch(msg.getFrom());
                    SendPort<WebDataMessage> p = msg.getFrom();
                    if (msg instanceof HttpStreamOpened) {
                        p = this.wrapAsSSE(p);
                    }
                    this.peer = p;
                    continue;
                }
                if (!(message instanceof WebDataMessage)) continue;
                this.postMessage((WebDataMessage)message);
            }
        }
        catch (Throwable throwable) {
            actors.remove(this.self());
            throw throwable;
        }
    }

    private SendPort<WebDataMessage> wrapAsSSE(SendPort<WebDataMessage> actor) {
        return Channels.mapSend(actor, (Function)new Function<WebDataMessage, WebDataMessage>(){

            public final WebDataMessage apply(WebDataMessage f) {
                return new WebDataMessage(f.getFrom(), SSE.event((String)f.getStringBody()));
            }
        });
    }

    private void postMessage(WebDataMessage webDataMessage) throws InterruptedException, SuspendExecution {
        if (this.peer != null) {
            this.peer.send((Object)webDataMessage);
        }
        if (webDataMessage.getFrom().equals(this.peer)) {
            for (SendPort sendPort : actors) {
                if (sendPort == this.self()) continue;
                sendPort.send((Object)webDataMessage);
            }
        }
    }

    protected final WebMessage handleLifecycleMessage(LifecycleMessage m) {
        if (m instanceof ExitMessage) {
            actors.remove(((ExitMessage)m).getActor());
        }
        return (WebMessage)super.handleLifecycleMessage(m);
    }
}

