/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors;

import co.paralleluniverse.strands.SettableFuture;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractWebActorTest {
    private static final int DEFAULT_TIMEOUT = 60000;
    private final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeout).setConnectionRequestTimeout(this.timeout).setSocketTimeout(this.timeout).build();
    protected int timeout = 60000;

    protected AbstractWebActorTest() {
    }

    @Test
    public final void testHttpMsg() throws IOException, InterruptedException, ExecutionException {
        HttpGet httpGet = new HttpGet("http://localhost:8080");
        try (CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.requestConfig).build();){
            CloseableHttpResponse res = client.execute((HttpUriRequest)httpGet);
            Assert.assertEquals((long)200L, (long)res.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"text/html", (Object)res.getFirstHeader("Content-Type").getValue());
            Assert.assertEquals((Object)"12", (Object)res.getFirstHeader("Content-Length").getValue());
            Assert.assertEquals((Object)"httpResponse", (Object)EntityUtils.toString((HttpEntity)res.getEntity()));
        }
    }

    @Test
    public final void testHttpNotFound() throws IOException, InterruptedException, ExecutionException {
        HttpGet httpGet = new HttpGet("http://localhost:8080/notfound");
        try (CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.requestConfig).build();){
            CloseableHttpResponse res = client.execute((HttpUriRequest)httpGet);
            Assert.assertEquals((long)404L, (long)res.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testDie() throws IOException, InterruptedException, ExecutionException {
        HttpGet httpGet = new HttpGet("http://localhost:8080/die");
        try (CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.requestConfig).build();){
            CloseableHttpResponse res = client.execute((HttpUriRequest)httpGet);
            Assert.assertEquals((long)500L, (long)res.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)EntityUtils.toString((HttpEntity)res.getEntity()).contains("die"));
        }
    }

    @Test
    public final void testHttpRedirect() throws IOException, InterruptedException, ExecutionException {
        HttpGet httpGet = new HttpGet("http://localhost:8080/redirect");
        try (CloseableHttpClient client = HttpClients.custom().disableRedirectHandling().setDefaultRequestConfig(this.requestConfig).build();){
            CloseableHttpResponse res = client.execute((HttpUriRequest)httpGet);
            String s = EntityUtils.toString((HttpEntity)res.getEntity());
            System.out.println(s);
            Assert.assertEquals((long)302L, (long)res.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)res.getFirstHeader("Location").getValue().endsWith("/foo"));
        }
    }

    @Test
    public final void testWebSocketMsg() throws IOException, InterruptedException, ExecutionException, DeploymentException {
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpGet httpGet = new HttpGet("http://localhost:8080");
        HttpClients.custom().setDefaultRequestConfig(this.requestConfig).setDefaultCookieStore((CookieStore)cookieStore).build().execute((HttpUriRequest)httpGet, (ResponseHandler)new BasicResponseHandler());
        SettableFuture res = new SettableFuture();
        WebSocketContainer wsContainer = ContainerProvider.getWebSocketContainer();
        wsContainer.setAsyncSendTimeout((long)this.timeout);
        wsContainer.setDefaultMaxSessionIdleTimeout((long)this.timeout);
        try (Session ignored = wsContainer.connectToServer(AbstractWebActorTest.sendAndGetTextEndPoint("test it", (SettableFuture<String>)res), this.getClientEndPointConfig((CookieStore)cookieStore), URI.create("ws://localhost:8080/ws"));){
            String s = (String)res.get();
            Assert.assertEquals((Object)"test it", (Object)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testSSE() throws IOException, InterruptedException, DeploymentException, ExecutionException {
        try (Client client = null;){
            client = ((ClientBuilder)ClientBuilder.newBuilder().register(SseFeature.class)).build();
            client.property("jersey.config.client.connectTimeout", (Object)this.timeout);
            client.property("jersey.config.client.readTimeout", (Object)this.timeout);
            Response resp = client.target("http://localhost:8080/ssechannel").request().get();
            NewCookie session = (NewCookie)resp.getCookies().get(this.getSessionIdCookieName());
            final EventInput eventInput = (EventInput)resp.readEntity(EventInput.class);
            final SettableFuture res = new SettableFuture();
            new Thread(new Runnable(){

                @Override
                public final void run() {
                    try {
                        InboundEvent inboundEvent;
                        while (!eventInput.isClosed() && !res.isDone() && (inboundEvent = (InboundEvent)eventInput.read()) != null) {
                            res.set(inboundEvent.readData(String.class));
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        res.setException(t);
                    }
                }
            }).start();
            client.target("http://localhost:8080/ssepublish").request().cookie((Cookie)session).post(Entity.text((Object)"test it"));
            String s = (String)res.get();
            Assert.assertEquals((Object)"test it", (Object)s);
        }
    }

    protected abstract String getSessionIdCookieName();

    protected ClientEndpointConfig getClientEndPointConfig(CookieStore cs) {
        return ClientEndpointConfig.Builder.create().build();
    }

    private static Endpoint sendAndGetTextEndPoint(final String sendText, final SettableFuture<String> res) {
        return new Endpoint(){

            public void onOpen(Session session, EndpointConfig config) {
                session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                    public final void onMessage(String text) {
                        res.set((Object)text);
                    }
                });
                try {
                    session.getBasicRemote().sendText(sendText);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }
}

