/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.embedded.containers;

import co.paralleluniverse.embedded.containers.AbstractEmbeddedServer;
import co.paralleluniverse.embedded.containers.EmbeddedServer;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.RequestLimit;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.util.ConstructorInstanceFactory;
import io.undertow.websockets.jsr.JsrWebSocketFilter;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import java.util.Collections;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.websocket.server.ServerContainer;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public final class UndertowServer
extends AbstractEmbeddedServer {
    private static final String ANY_LOCAL_ADDRESS = "0.0.0.0";
    private DeploymentInfo deployment;
    private Undertow server;

    private void build() {
        if (this.deployment != null) {
            return;
        }
        this.deployment = Servlets.deployment().setDeploymentName("").setClassLoader(ClassLoader.getSystemClassLoader()).setContextPath("/");
    }

    @Override
    public final EmbeddedServer.ServletDesc addServlet(String name, Class<? extends Servlet> servletClass, String mapping) {
        this.build();
        ServletInfo info = Servlets.servlet((String)name, servletClass).addMapping(mapping).setAsyncSupported(true);
        this.deployment.addServlet(info);
        return new UndertowServletDesc(info);
    }

    @Override
    public final void start() throws Exception {
        DeploymentManager servletsContainer = Servlets.defaultContainer().addDeployment(this.deployment);
        servletsContainer.deploy();
        HttpHandler handler = servletsContainer.start();
        handler = Handlers.requestLimitingHandler((RequestLimit)new RequestLimit(this.maxConn), (HttpHandler)handler);
        this.server = Undertow.builder().setHandler(handler).setIoThreads(this.nThreads).addHttpListener(this.port, ANY_LOCAL_ADDRESS).build();
        new Thread(new Runnable(){

            @Override
            public final void run() {
                UndertowServer.this.server.start();
            }
        }).start();
        UndertowServer.waitUrlAvailable("http://localhost:" + this.port);
    }

    @Override
    public final void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Override
    public final void addServletContextListener(Class<? extends ServletContextListener> scl) {
        this.build();
        ListenerInfo li = Servlets.listener(scl);
        this.deployment.addListener(li);
    }

    @Override
    public final void enableWebsockets() throws Exception {
        Xnio xnio = Xnio.getInstance((String)"nio", (ClassLoader)this.getClass().getClassLoader());
        XnioWorker worker = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
        ClassIntrospecter ci = new ClassIntrospecter(){

            public final <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) {
                try {
                    return new ConstructorInstanceFactory(clazz.getDeclaredConstructor(new Class[0]));
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ServerWebSocketContainer wsc = new ServerWebSocketContainer(ci, worker, (ByteBufferPool)new DefaultByteBufferPool(true, 100), (ThreadSetupAction)new CompositeThreadSetupAction(Collections.EMPTY_LIST), false, false);
        FilterInfo fi = new FilterInfo("filter", JsrWebSocketFilter.class);
        fi.setAsyncSupported(true);
        this.deployment.addFilter(fi).addFilterUrlMapping("filter", "/*", DispatcherType.REQUEST).addServletContextAttribute(ServerContainer.class.getName(), (Object)wsc);
    }

    @Override
    public final void setResourceBase(String resourceBaseUrl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static final class UndertowServletDesc
    implements EmbeddedServer.ServletDesc {
        private final ServletInfo impl;

        public UndertowServletDesc(ServletInfo info) {
            this.impl = info;
        }

        @Override
        public final EmbeddedServer.ServletDesc setInitParameter(String name, String value) {
            this.impl.addInitParam(name, value);
            return this;
        }

        @Override
        public final EmbeddedServer.ServletDesc setLoadOnStartup(int load) {
            this.impl.setLoadOnStartup(Integer.valueOf(load));
            return this;
        }
    }
}

