/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.embedded.containers;

import co.paralleluniverse.embedded.containers.AbstractEmbeddedServer;
import co.paralleluniverse.embedded.containers.EmbeddedServer;
import java.io.File;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContextListener;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.websocket.server.WsSci;

public final class TomcatServer
extends AbstractEmbeddedServer {
    private static final String defaultResDir = System.getProperty(TomcatServer.class.getName() + ".defaultResDir", "./build");
    protected final Tomcat tomcat = new Tomcat();
    protected final Context context;

    public TomcatServer() {
        this(defaultResDir);
    }

    public TomcatServer(String resDir) {
        this.context = this.tomcat.addContext("/", new File(resDir).getAbsolutePath());
    }

    @Override
    public final EmbeddedServer.ServletDesc addServlet(String name, Class<? extends Servlet> servletClass, String mapping) {
        Wrapper w = Tomcat.addServlet((Context)this.context, (String)name, (String)servletClass.getName());
        w.addMapping(mapping);
        return new TomcatServletDesc(w);
    }

    @Override
    public final void start() throws Exception {
        this.tomcat.setPort(this.port);
        this.tomcat.getConnector().setAttribute("maxThreads", (Object)this.nThreads);
        this.tomcat.getConnector().setAttribute("acceptCount", (Object)this.maxConn);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public final void run() {
                try {
                    TomcatServer.this.tomcat.stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
        });
        this.tomcat.start();
        new Thread(){

            @Override
            public final void run() {
                TomcatServer.this.tomcat.getServer().await();
            }
        }.start();
    }

    @Override
    public final void stop() throws Exception {
        this.tomcat.stop();
        this.tomcat.getConnector().destroy();
        this.tomcat.destroy();
    }

    @Override
    public final void enableWebsockets() throws Exception {
        this.context.addServletContainerInitializer((ServletContainerInitializer)new WsSci(), null);
    }

    @Override
    public final void addServletContextListener(Class<? extends ServletContextListener> scl) {
        StandardContext tomcatCtx = (StandardContext)this.context;
        tomcatCtx.addApplicationListener(scl.getName());
    }

    @Override
    public final void setResourceBase(String resourceBaseUrl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static final class TomcatServletDesc
    implements EmbeddedServer.ServletDesc {
        private final Wrapper impl;

        public TomcatServletDesc(Wrapper w) {
            this.impl = w;
        }

        @Override
        public final EmbeddedServer.ServletDesc setInitParameter(String name, String value) {
            this.impl.addInitParameter(name, value);
            return this;
        }

        @Override
        public final EmbeddedServer.ServletDesc setLoadOnStartup(int load) {
            this.impl.setLoadOnStartup(load);
            return this;
        }
    }
}

