/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.embedded.containers;

import co.paralleluniverse.embedded.containers.AbstractEmbeddedServer;
import co.paralleluniverse.embedded.containers.EmbeddedServer;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.RequestLimit;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletInfo;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;

public class UndertowServer
extends AbstractEmbeddedServer {
    private static final String ANY_LOCAL_ADDRESS = "0.0.0.0";
    private DeploymentInfo deployment;
    private Undertow server;

    private void build() {
        if (this.deployment != null) {
            return;
        }
        this.deployment = Servlets.deployment().setDeploymentName("").setClassLoader(ClassLoader.getSystemClassLoader()).setContextPath("/");
    }

    @Override
    public EmbeddedServer.ServletDesc addServlet(String name, Class<? extends Servlet> servletClass, String mapping) {
        this.build();
        ServletInfo info = Servlets.servlet((String)name, servletClass).addMapping(mapping).setAsyncSupported(true);
        this.deployment.addServlet(info);
        return new UndertowServletDesc(info);
    }

    @Override
    public void start() throws Exception {
        DeploymentManager servletsContainer = Servlets.defaultContainer().addDeployment(this.deployment);
        servletsContainer.deploy();
        HttpHandler handler = servletsContainer.start();
        handler = Handlers.requestLimitingHandler((RequestLimit)new RequestLimit(this.maxConn), (HttpHandler)handler);
        this.server = Undertow.builder().setHandler(handler).setIoThreads(this.nThreads).addHttpListener(this.port, ANY_LOCAL_ADDRESS).build();
        new Thread(new Runnable(){

            @Override
            public void run() {
                UndertowServer.this.server.start();
            }
        }).start();
        UndertowServer.waitUrlAvailable("http://localhost:" + this.port);
    }

    @Override
    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Override
    public void addServletContextListener(Class<? extends ServletContextListener> scl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void enableWebsockets() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static class UndertowServletDesc
    implements EmbeddedServer.ServletDesc {
        private final ServletInfo impl;

        public UndertowServletDesc(ServletInfo info) {
            this.impl = info;
        }

        @Override
        public EmbeddedServer.ServletDesc setInitParameter(String name, String value) {
            this.impl.addInitParam(name, value);
            return this;
        }

        @Override
        public EmbeddedServer.ServletDesc setLoadOnStartup(int load) {
            this.impl.setLoadOnStartup(Integer.valueOf(load));
            return this;
        }
    }
}

