/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.embedded.containers;

import co.paralleluniverse.embedded.containers.AbstractEmbeddedServer;
import co.paralleluniverse.embedded.containers.EmbeddedServer;
import java.util.EventListener;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class JettyServer
extends AbstractEmbeddedServer {
    private Server server;
    private ServerConnector http;
    private ServletContextHandler context;
    private boolean error;
    private boolean wsEnabled;

    private void build() {
        if (this.server != null) {
            return;
        }
        this.server = new Server((ThreadPool)new QueuedThreadPool(this.nThreads, this.nThreads));
        this.http = new ServerConnector(this.server);
        this.http.setPort(this.port);
        this.http.setAcceptQueueSize(this.maxConn);
        this.server.addConnector((Connector)this.http);
        this.context = new ServletContextHandler(1);
    }

    @Override
    public EmbeddedServer.ServletDesc addServlet(String name, Class<? extends Servlet> servletClass, String mapping) {
        if (this.context == null) {
            this.build();
        }
        ServletHolder sh = new ServletHolder(servletClass);
        this.context.addServlet(sh, mapping);
        return new JettyServletDesc(sh);
    }

    @Override
    public void addServletContextListener(Class<? extends ServletContextListener> scl) {
        if (this.context == null) {
            this.build();
        }
        try {
            this.context.addEventListener((EventListener)scl.newInstance());
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.context == null) {
            this.build();
        }
        this.server.setHandler((Handler)this.context);
        if (this.wsEnabled) {
            WebSocketServerContainerInitializer.configureContext((ServletContextHandler)this.context);
        }
        this.server.start();
    }

    @Override
    public void stop() throws Exception {
        this.server.stop();
    }

    @Override
    public void enableWebsockets() throws Exception {
        this.wsEnabled = true;
    }

    private static class JettyServletDesc
    implements EmbeddedServer.ServletDesc {
        private final ServletHolder impl;

        public JettyServletDesc(ServletHolder sh) {
            this.impl = sh;
        }

        @Override
        public EmbeddedServer.ServletDesc setInitParameter(String name, String value) {
            this.impl.setInitParameter(name, value);
            return this;
        }

        @Override
        public EmbeddedServer.ServletDesc setLoadOnStartup(int load) {
            this.impl.setInitOrder(load);
            return this;
        }
    }
}

