/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.servlet;

import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.fibers.servlet.FiberHttpServletRequest;
import co.paralleluniverse.fibers.servlet.FiberServletContext;
import co.paralleluniverse.strands.SuspendableRunnable;
import java.io.IOException;
import java.util.concurrent.ForkJoinPool;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FiberHttpServlet
extends HttpServlet {
    private static final String PROP_ASYNC_TIMEOUT = FiberHttpServlet.class.getName() + ".asyncTimeout";
    static final Long asyncTimeout;
    public static final String PROP_DEBUG_BYPASS_TO_REGULAR_FJP;
    static final boolean debugBypassToRegularJFPGlobal;
    public static final String PROP_DISABLE_SYNC_EXCEPTIONS;
    static final boolean disableSyncExceptionsGlobal;
    public static final String PROP_DISABLE_SYNC_FORWARD;
    static final boolean disableSyncForwardGlobal;
    public static final String PROP_DISABLE_JETTY_ASYNC_FIXES;
    static final Boolean disableJettyAsyncFixesGlobal;
    public static final String PROP_DISABLE_TOMCAT_ASYNC_FIXES;
    static final Boolean disableTomcatAsyncFixesGlobal;
    private static final long serialVersionUID = 1L;
    private static final String FIBER_ASYNC_REQUEST_EXCEPTION = "co.paralleluniverse.fibers.servlet.exception";
    private final ThreadLocal<AsyncContext> currentAsyncContext = new ThreadLocal();
    private int stackSize = -1;
    private transient FiberServletContext contextAD;
    private ForkJoinPool fjp = new ForkJoinPool();
    boolean debugBypassToRegularJFP;
    boolean disableSyncExceptions;
    boolean disableSyncForward;
    boolean disableJettyAsyncFixes;
    boolean disableTomcatAsyncFixes;

    public ServletContext getServletContext() {
        return this.disableSyncForward ? super.getServletContext() : this.contextAD;
    }

    public void init(ServletConfig config) throws ServletException {
        String disableTF;
        String disableJF;
        String disableSF;
        String disableSE;
        String debugByPassToJFP;
        super.init(config);
        this.contextAD = new FiberServletContext(config.getServletContext(), this.currentAsyncContext);
        String ss = config.getInitParameter("stack-size");
        if (ss != null) {
            this.stackSize = Integer.parseInt(ss);
        }
        if ((debugByPassToJFP = config.getInitParameter(PROP_DEBUG_BYPASS_TO_REGULAR_FJP)) != null) {
            this.debugBypassToRegularJFP = debugBypassToRegularJFPGlobal;
        }
        if ((disableSE = config.getInitParameter(PROP_DISABLE_SYNC_EXCEPTIONS)) != null) {
            this.disableSyncExceptions = disableSyncExceptionsGlobal;
        }
        if ((disableSF = config.getInitParameter(PROP_DISABLE_SYNC_FORWARD)) != null) {
            this.disableSyncForward = disableSyncForwardGlobal;
        }
        if ((disableJF = config.getInitParameter(PROP_DISABLE_JETTY_ASYNC_FIXES)) != null) {
            boolean bl = disableJettyAsyncFixesGlobal != null ? disableJettyAsyncFixesGlobal : (this.disableJettyAsyncFixes = !FiberHttpServlet.isJetty(config));
        }
        if ((disableTF = config.getInitParameter(PROP_DISABLE_TOMCAT_ASYNC_FIXES)) != null) {
            this.disableTomcatAsyncFixes = disableTomcatAsyncFixesGlobal != null ? disableTomcatAsyncFixesGlobal : !FiberHttpServlet.isTomcat(config);
        }
    }

    protected final void setStackSize(int stackSize) {
        this.stackSize = stackSize;
    }

    protected final int getStackSize() {
        return this.stackSize;
    }

    @Suspendable
    public final void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest r;
        HttpServletResponse response;
        HttpServletRequest request;
        Throwable ex;
        if (!this.disableSyncExceptions && DispatcherType.ASYNC.equals((Object)req.getDispatcherType()) && (ex = (Throwable)req.getAttribute(FIBER_ASYNC_REQUEST_EXCEPTION)) != null) {
            throw new ServletException(ex);
        }
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException cce) {
            throw new ServletException("Unsupported non-HTTP request or response detected");
        }
        if (!this.disableTomcatAsyncFixes) {
            req.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        }
        AsyncContext ac = req.startAsync();
        if (asyncTimeout != null) {
            ac.setTimeout(asyncTimeout.longValue());
        }
        HttpServletRequest httpServletRequest = r = !this.disableJettyAsyncFixes ? new FiberHttpServletRequest(this, request) : request;
        if (this.debugBypassToRegularJFP) {
            this.fjp.execute(new ServletRunnable(this, ac, r, response));
        } else {
            new Fiber(null, this.stackSize, (SuspendableRunnable)new ServletSuspendableRunnable(this, ac, r, response)).start();
        }
    }

    @Suspendable
    final void exec(FiberHttpServlet servlet, AsyncContext ac, HttpServletRequest request, HttpServletResponse response) {
        if (!this.disableSyncExceptions) {
            try {
                this.exec0(servlet, ac, request, response);
            }
            catch (IOException | ServletException ex) {
                servlet.log("Exception in servlet's fiber, dispatching to container", ex);
                request.setAttribute(FIBER_ASYNC_REQUEST_EXCEPTION, (Object)ex);
                if (!this.disableSyncForward) {
                    servlet.currentAsyncContext.set(null);
                }
                ac.dispatch();
            }
        } else {
            try {
                this.exec0(servlet, ac, request, response);
            }
            catch (Throwable t) {
                servlet.log("Error during pool-based execution", t);
                ((HttpServletResponse)ac.getResponse()).setStatus(500);
                ac.complete();
            }
        }
    }

    private void exec0(FiberHttpServlet servlet, AsyncContext ac, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.disableSyncForward) {
            servlet.currentAsyncContext.set(ac);
        }
        servlet.service(request, response);
        ac.complete();
    }

    private static boolean isJetty(ServletConfig config) {
        return config.getClass().getName().startsWith("org.eclipse.jetty.");
    }

    private static boolean isTomcat(ServletConfig config) {
        return config.getClass().getName().startsWith("org.apache.tomcat.");
    }

    private static Long getLong(String propName) {
        String asyncTimeoutS = System.getProperty(propName);
        if (asyncTimeoutS != null) {
            Long l = null;
            try {
                l = Long.parseLong(asyncTimeoutS);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return l;
        }
        return null;
    }

    private static Boolean getBoolean(String propName) {
        String disableJettyAsyncFixesGlobalS = System.getProperty(propName);
        if (disableJettyAsyncFixesGlobalS != null) {
            Boolean b = null;
            if (Boolean.TRUE.toString().equals(disableJettyAsyncFixesGlobalS)) {
                b = true;
            } else if (Boolean.FALSE.toString().equals(disableJettyAsyncFixesGlobalS)) {
                b = false;
            }
            return b;
        }
        return null;
    }

    static {
        PROP_DEBUG_BYPASS_TO_REGULAR_FJP = FiberHttpServlet.class.getName() + ".debug.bypassToRegularFJP";
        debugBypassToRegularJFPGlobal = SystemProperties.isEmptyOrTrue((String)PROP_DEBUG_BYPASS_TO_REGULAR_FJP);
        PROP_DISABLE_SYNC_EXCEPTIONS = FiberHttpServlet.class.getName() + ".disableSyncExceptions";
        disableSyncExceptionsGlobal = SystemProperties.isEmptyOrTrue((String)PROP_DISABLE_SYNC_EXCEPTIONS);
        PROP_DISABLE_SYNC_FORWARD = FiberHttpServlet.class.getName() + ".disableSyncForward";
        disableSyncForwardGlobal = SystemProperties.isEmptyOrTrue((String)PROP_DISABLE_SYNC_FORWARD);
        PROP_DISABLE_JETTY_ASYNC_FIXES = FiberHttpServlet.class.getName() + ".disableJettyAsyncFixes";
        PROP_DISABLE_TOMCAT_ASYNC_FIXES = FiberHttpServlet.class.getName() + ".disableTomcatAsyncFixes";
        asyncTimeout = FiberHttpServlet.getLong(PROP_ASYNC_TIMEOUT);
        disableJettyAsyncFixesGlobal = FiberHttpServlet.getBoolean(PROP_DISABLE_JETTY_ASYNC_FIXES);
        disableTomcatAsyncFixesGlobal = FiberHttpServlet.getBoolean(PROP_DISABLE_TOMCAT_ASYNC_FIXES);
    }

    private static class ServletRunnable
    implements Runnable {
        private final FiberHttpServlet servlet;
        private final AsyncContext ac;
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        public ServletRunnable(FiberHttpServlet servlet, AsyncContext ac, HttpServletRequest request, HttpServletResponse response) {
            this.servlet = servlet;
            this.ac = ac;
            this.request = request;
            this.response = response;
        }

        @Override
        public final void run() {
            this.servlet.exec(this.servlet, this.ac, this.request, this.response);
        }
    }

    private static final class ServletSuspendableRunnable
    implements SuspendableRunnable {
        private final AsyncContext ac;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final FiberHttpServlet servlet;

        public ServletSuspendableRunnable(FiberHttpServlet servlet, AsyncContext ac, HttpServletRequest request, HttpServletResponse response) {
            this.servlet = servlet;
            this.ac = ac;
            this.request = request;
            this.response = response;
        }

        public final void run() throws SuspendExecution, InterruptedException {
            this.servlet.exec(this.servlet, this.ac, this.request, this.response);
        }
    }
}

