/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.servlet;

import co.paralleluniverse.fibers.servlet.FiberServletRequest;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

class FiberRequestDispatcher
implements RequestDispatcher {
    public static final String SLASH = "/";
    private final String path;
    private final AsyncContext ac;

    public FiberRequestDispatcher(String path, AsyncContext ac) {
        this.path = path;
        this.ac = ac;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletRequest baseReq = ((FiberServletRequest)request).getReq();
        if (baseReq != this.ac.getRequest() || response != this.ac.getResponse()) {
            throw new UnsupportedOperationException("Changing the request or the response in forward is not yet supported from fiber servlet");
        }
        response.reset();
        if (this.ac.getRequest() instanceof HttpServletRequest) {
            this.ac.dispatch(FiberRequestDispatcher.relToAbs((HttpServletRequest)this.ac.getRequest(), this.path));
        } else {
            this.ac.dispatch(this.path);
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException {
        throw new UnsupportedOperationException("Include calls are not yet supported by fiber servlet");
    }

    public static String relToAbs(HttpServletRequest req, String rel) {
        if (!rel.startsWith(SLASH)) {
            String relTo = FiberRequestDispatcher.addPaths(req.getServletPath(), req.getPathInfo());
            int slash = relTo.lastIndexOf(SLASH);
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : SLASH;
            rel = FiberRequestDispatcher.addPaths(relTo, rel);
        }
        return rel;
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith(SLASH)) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith(SLASH)) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, SLASH);
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }
}

