/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.servlet;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.fibers.servlet.FiberHttpServletRequest;
import co.paralleluniverse.fibers.servlet.FiberServletConfig;
import co.paralleluniverse.fibers.servlet.FiberServletContext;
import co.paralleluniverse.strands.SuspendableRunnable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FiberNewHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient FiberServletConfig configAD;
    private transient FiberServletContext contextAD;
    private final ThreadLocal<AsyncContext> currentAsyncContext = new ThreadLocal();
    private int stackSize = -1;
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");

    public final ServletConfig getServletConfig() {
        return this.configAD;
    }

    public ServletContext getServletContext() {
        return this.contextAD;
    }

    public void init(ServletConfig config) throws ServletException {
        this.contextAD = new FiberServletContext(config.getServletContext(), this.currentAsyncContext);
        this.configAD = new FiberServletConfig(config, this.contextAD);
        String sss = config.getInitParameter("stack-size");
        if (sss != null) {
            this.stackSize = Integer.parseInt(sss);
        }
        this.init();
    }

    protected void setStackSize(int stackSize) {
        this.stackSize = stackSize;
    }

    protected int getStackSize() {
        return this.stackSize;
    }

    @Suspendable
    public final void service(final ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("non-HTTP request or response");
        }
        HttpServletRequest request = (HttpServletRequest)req;
        final HttpServletResponse response = (HttpServletResponse)res;
        req.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        final AsyncContext ac = req.startAsync();
        ac.setTimeout(120000L);
        final FiberHttpServletRequest srad = new FiberHttpServletRequest(request);
        new Fiber(null, this.stackSize, new SuspendableRunnable(){

            public void run() throws SuspendExecution, InterruptedException {
                try {
                    FiberNewHttpServlet.this.currentAsyncContext.set(ac);
                    FiberNewHttpServlet.this.service(srad, response);
                }
                catch (Exception ex) {
                    FiberNewHttpServlet.this.log("Exception in fiber servlet", ex);
                }
                finally {
                    if (req.isAsyncStarted()) {
                        ac.complete();
                    }
                    FiberNewHttpServlet.this.currentAsyncContext.set(null);
                }
            }
        }).start();
    }

    @Suspendable
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if (method.equals(METHOD_GET)) {
            long lastModified = this.getLastModified(req);
            if (lastModified == -1L) {
                this.doGet(req, resp);
            } else {
                long ifModifiedSince = req.getDateHeader(HEADER_IFMODSINCE);
                if (ifModifiedSince < lastModified) {
                    this.maybeSetLastModified(resp, lastModified);
                    this.doGet(req, resp);
                } else {
                    resp.setStatus(304);
                }
            }
        } else if (method.equals(METHOD_HEAD)) {
            long lastModified = this.getLastModified(req);
            this.maybeSetLastModified(resp, lastModified);
            this.doHead(req, resp);
        } else if (method.equals(METHOD_POST)) {
            this.doPost(req, resp);
        } else if (method.equals(METHOD_PUT)) {
            this.doPut(req, resp);
        } else if (method.equals(METHOD_DELETE)) {
            this.doDelete(req, resp);
        } else if (method.equals(METHOD_OPTIONS)) {
            this.doOptions(req, resp);
        } else if (method.equals(METHOD_TRACE)) {
            this.doTrace(req, resp);
        } else {
            String errMsg = lStrings.getString("http.method_not_implemented");
            Object[] errArgs = new Object[]{method};
            errMsg = MessageFormat.format(errMsg, errArgs);
            resp.sendError(501, errMsg);
        }
    }

    private void maybeSetLastModified(HttpServletResponse resp, long lastModified) {
        if (resp.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (lastModified >= 0L) {
            resp.setDateHeader(HEADER_LASTMOD, lastModified);
        }
    }

    @Suspendable
    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    @Suspendable
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    @Suspendable
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    @Suspendable
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    @Suspendable
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    @Suspendable
    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    @Suspendable
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }
}

