/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.okhttp;

import co.paralleluniverse.fibers.FiberUtil;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.okhttp.FiberOkHttpClient;
import co.paralleluniverse.strands.SuspendableCallable;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.OkUrlFactory;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.apache.OkApacheClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

public class FiberOkHttpUtil {
    public static Response executeInFiber(FiberOkHttpClient client, Request request) throws InterruptedException, IOException {
        return FiberOkHttpUtil.executeInFiber(client.newCall(request));
    }

    public static Response executeInFiber(final Call call) throws InterruptedException, IOException {
        return (Response)FiberUtil.runInFiberChecked((SuspendableCallable)new SuspendableCallable<Response>(){

            public Response run() throws SuspendExecution, InterruptedException {
                try {
                    return call.execute();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, IOException.class);
    }

    public static HttpURLConnection openInFiber(final OkUrlFactory factory, final URL url) throws InterruptedException {
        return (HttpURLConnection)FiberUtil.runInFiberRuntime((SuspendableCallable)new SuspendableCallable<HttpURLConnection>(){

            public HttpURLConnection run() throws SuspendExecution, InterruptedException {
                return factory.open(url);
            }
        });
    }

    public static HttpResponse executeInFiber(final OkApacheClient client, final HttpRequestBase req) throws InterruptedException, IOException {
        return (HttpResponse)FiberUtil.runInFiberChecked((SuspendableCallable)new SuspendableCallable<HttpResponse>(){

            public HttpResponse run() throws SuspendExecution, InterruptedException {
                try {
                    return client.execute((HttpUriRequest)req);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, IOException.class);
    }

    private FiberOkHttpUtil() {
    }
}

