/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.okhttp;

import co.paralleluniverse.fibers.FiberAsync;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import com.squareup.okhttp.CallProxy;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class FiberCall
extends CallProxy {
    public FiberCall(OkHttpClient client, Request originalRequest) {
        super(client, originalRequest);
    }

    @Suspendable
    public Response execute() throws IOException {
        try {
            return (Response)new FiberAsyncCallback().run();
        }
        catch (SuspendExecution | InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private class FiberAsyncCallback
    extends FiberAsync<Response, IOException>
    implements Callback {
        private FiberAsyncCallback() {
        }

        protected void requestAsync() {
            FiberCall.this.enqueue(this);
        }

        public void onFailure(Request rqst, IOException ioe) {
            this.asyncFailed(ioe);
        }

        public void onResponse(Response rspns) throws IOException {
            this.asyncCompleted(rspns);
        }

        protected Response requestSync() throws IOException, InterruptedException, ExecutionException {
            return FiberCall.super.execute();
        }
    }
}

