/*
 * COMSAT
 * Copyright (c) 2013-2015, Parallel Universe Software Co. All rights reserved.
 *
 * This program and the accompanying materials are dual-licensed under
 * either the terms of the Eclipse Public License v1.0 as published by
 * the Eclipse Foundation
 *
 *   or (per the licensee's choosing)
 *
 * under the terms of the GNU Lesser General Public License version 3.0
 * as published by the Free Software Foundation.
 */
package co.paralleluniverse.fibers.jdbc;

import co.paralleluniverse.common.util.CheckedCallable;
import co.paralleluniverse.fibers.Suspendable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

/**
 * @author eitan
 */
public class FiberConnection implements Connection {
    private final Connection conn;
    private final ExecutorService executor;

    FiberConnection(final Connection conn, final ExecutorService exec) {
        this.conn = conn;
        this.executor = exec;
    }

    @Override
    @Suspendable
    public FiberStatement createStatement() throws SQLException {
        final Statement statement = JDBCFiberAsync.exec(executor, new CheckedCallable<Statement, SQLException>() {
            @Override
            public Statement call() throws SQLException {
                return conn.createStatement();
            }
        });
        return new FiberStatement(statement, executor);
    }
    
    @Override
    @Suspendable
    public FiberPreparedStatement prepareStatement(final String sql) throws SQLException {
        final PreparedStatement prepareStatement = JDBCFiberAsync.exec(executor, new CheckedCallable<PreparedStatement, SQLException>() {
            @Override
            public PreparedStatement call() throws SQLException {
                return conn.prepareStatement(sql);
            }
        });
        return new FiberPreparedStatement(prepareStatement, executor);
    }

    @Override
    @Suspendable
    public FiberPreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final PreparedStatement prepareStatement = JDBCFiberAsync.exec(executor, new CheckedCallable<PreparedStatement, SQLException>() {
            @Override
            public PreparedStatement call() throws SQLException {
                return conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        });
        return new FiberPreparedStatement(prepareStatement, executor);
    }

    @Override
    @Suspendable
    public FiberPreparedStatement prepareStatement(final String sql, final int autoGeneratedKeys) throws SQLException {
        final PreparedStatement prepareStatement = JDBCFiberAsync.exec(executor, new CheckedCallable<PreparedStatement, SQLException>() {
            @Override
            public PreparedStatement call() throws SQLException {
                return conn.prepareStatement(sql, autoGeneratedKeys);
            }
        });
        return new FiberPreparedStatement(prepareStatement, executor);
    }

    @Override
    @Suspendable
    public FiberPreparedStatement prepareStatement(final String sql, final int[] columnIndexes) throws SQLException {
        final PreparedStatement prepareStatement = JDBCFiberAsync.exec(executor, new CheckedCallable<PreparedStatement, SQLException>() {
            @Override
            public PreparedStatement call() throws SQLException {
                return conn.prepareStatement(sql, columnIndexes);
            }
        });
        return new FiberPreparedStatement(prepareStatement, executor);
    }

    @Override
    @Suspendable
    public FiberPreparedStatement prepareStatement(final String sql, final String[] columnNames) throws SQLException {
        final PreparedStatement prepareStatement = JDBCFiberAsync.exec(executor, new CheckedCallable<PreparedStatement, SQLException>() {
            @Override
            public PreparedStatement call() throws SQLException {
                return conn.prepareStatement(sql, columnNames);
            }
        });
        return new FiberPreparedStatement(prepareStatement, executor);
    }

    @Override
    @Suspendable
    public FiberCallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final CallableStatement callableStatement = JDBCFiberAsync.exec(executor, new CheckedCallable<CallableStatement, SQLException>() {
            @Override
            public CallableStatement call() throws SQLException {
                return conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        });
        return new FiberCallableStatement(callableStatement, executor);
    }

    @Override
    @Suspendable
    public FiberCallableStatement prepareCall(final String sql) throws SQLException {
        final CallableStatement callableStatement = JDBCFiberAsync.exec(executor, new CheckedCallable<CallableStatement, SQLException>() {
            @Override
            public CallableStatement call() throws SQLException {
                return conn.prepareCall(sql);
            }
        });
        return new FiberCallableStatement(callableStatement, executor);
    }

    @Override
    @Suspendable
    public FiberCallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final CallableStatement callableStatement = JDBCFiberAsync.exec(executor, new CheckedCallable<CallableStatement, SQLException>() {
            @Override
            public CallableStatement call() throws SQLException {
                return conn.prepareCall(sql, resultSetType, resultSetConcurrency);
            }
        });
        return new FiberCallableStatement(callableStatement, executor);
    }

    @Override
    @Suspendable
    public String nativeSQL(final String sql) throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<String, SQLException>() {
            @Override
            public String call() throws SQLException {
                return conn.nativeSQL(sql);
            }
        });
    }

    @Override
    @Suspendable
    public void setAutoCommit(final boolean autoCommit) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.setAutoCommit(autoCommit);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public boolean getAutoCommit() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<Boolean, SQLException>() {
            @Override
            public Boolean call() throws SQLException {
                return conn.getAutoCommit();
            }
        });
    }

    @Override
    @Suspendable
    public void commit() throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.commit();
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public void rollback() throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.rollback();
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public void close() throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.close();
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public boolean isClosed() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<Boolean, SQLException>() {
            @Override
            public Boolean call() throws SQLException {
                return conn.isClosed();
            }
        });
    }

    @Override
    @Suspendable
    public FiberDatabaseMetaData getMetaData() throws SQLException {
        final DatabaseMetaData dbMeta = JDBCFiberAsync.exec(executor, new CheckedCallable<DatabaseMetaData, SQLException>() {
            @Override
            public DatabaseMetaData call() throws SQLException {
                return conn.getMetaData();
            }
        });
        return new FiberDatabaseMetaData(dbMeta, executor);
    }

    @Override
    @Suspendable
    public void setReadOnly(final boolean readOnly) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.setReadOnly(readOnly);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public boolean isReadOnly() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<Boolean, SQLException>() {
            @Override
            public Boolean call() throws SQLException {
                return conn.isReadOnly();
            }
        });
    }

    @Override
    @Suspendable
    public void setCatalog(final String catalog) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.setCatalog(catalog);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public String getCatalog() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<String, SQLException>() {
            @Override
            public String call() throws SQLException {
                return conn.getCatalog();
            }
        });
    }

    @Override
    @Suspendable
    public void setTransactionIsolation(final int level) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.setTransactionIsolation(level);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public int getTransactionIsolation() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<Integer, SQLException>() {
            @Override
            public Integer call() throws SQLException {
                return conn.getTransactionIsolation();
            }
        });
    }

    @Override
    @Suspendable
    public SQLWarning getWarnings() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<SQLWarning, SQLException>() {
            @Override
            public SQLWarning call() throws SQLException {
                return conn.getWarnings();
            }
        });
    }

    @Override
    @Suspendable
    public void clearWarnings() throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.clearWarnings();
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public FiberStatement createStatement(final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final Statement statement = JDBCFiberAsync.exec(executor, new CheckedCallable<Statement, SQLException>() {
            @Override
            public Statement call() throws SQLException {
                return conn.createStatement(resultSetType, resultSetConcurrency);
            }
        });
        return new FiberStatement(statement, executor);
    }

    @Override
    @Suspendable
    public FiberPreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final PreparedStatement stmt = JDBCFiberAsync.exec(executor, new CheckedCallable<PreparedStatement, SQLException>() {
            @Override
            public PreparedStatement call() throws SQLException {
                return conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
        });
        return new FiberPreparedStatement(stmt, executor);
    }

    @Override
    @Suspendable
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable< Map<String, Class<?>>, SQLException>() {
            @Override
            public Map<String, Class<?>> call() throws SQLException {
                return conn.getTypeMap();
            }
        });
    }

    @Override
    @Suspendable
    public void setTypeMap(final Map<String, Class<?>> map) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.setTypeMap(map);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public void setHoldability(final int holdability) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.setHoldability(holdability);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public int getHoldability() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<Integer, SQLException>() {
            @Override
            public Integer call() throws SQLException {
                return conn.getHoldability();
            }
        });
    }

    @Override
    @Suspendable
    public FiberSavepoint setSavepoint() throws SQLException {
        final Savepoint savepoint = JDBCFiberAsync.exec(executor, new CheckedCallable<Savepoint, SQLException>() {
            @Override
            public Savepoint call() throws SQLException {
                return conn.setSavepoint();
            }
        });
        return new FiberSavepoint(savepoint, executor);
    }

    @Override
    @Suspendable
    public FiberSavepoint setSavepoint(final String name) throws SQLException {
        final Savepoint savepoint = JDBCFiberAsync.exec(executor, new CheckedCallable<Savepoint, SQLException>() {
            @Override
            public Savepoint call() throws SQLException {
                return conn.setSavepoint(name);
            }
        });
        return new FiberSavepoint(savepoint, executor);
    }

    @Override
    @Suspendable
    public void rollback(final Savepoint savepoint) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.rollback(savepoint);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public void releaseSavepoint(final Savepoint savepoint) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.releaseSavepoint(savepoint);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public FiberStatement createStatement(final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final Statement statement = JDBCFiberAsync.exec(executor, new CheckedCallable<Statement, SQLException>() {
            @Override
            public Statement call() throws SQLException {
                return conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        });
        return new FiberStatement(statement, executor);
    }

    @Override
    @Suspendable
    public FiberClob createClob() throws SQLException {
        final Clob clob = JDBCFiberAsync.exec(executor, new CheckedCallable<Clob, SQLException>() {
            @Override
            public Clob call() throws SQLException {
                return conn.createClob();
            }
        });
        return new FiberClob(clob, executor);
    }

    @Override
    @Suspendable
    public FiberBlob createBlob() throws SQLException {
        final Blob blob = JDBCFiberAsync.exec(executor, new CheckedCallable<Blob, SQLException>() {
            @Override
            public Blob call() throws SQLException {
                return conn.createBlob();
            }
        });
        return new FiberBlob(blob, executor);
    }

    @Override
    @Suspendable
    public FiberNClob createNClob() throws SQLException {
        final NClob nclob = JDBCFiberAsync.exec(executor, new CheckedCallable<NClob, SQLException>() {
            @Override
            public NClob call() throws SQLException {
                return conn.createNClob();
            }
        });
        return new FiberNClob(nclob, executor);
    }

    @Override
    @Suspendable
    public FiberSQLXML createSQLXML() throws SQLException {
        final SQLXML sqlXML = JDBCFiberAsync.exec(executor, new CheckedCallable<SQLXML, SQLException>() {
            @Override
            public SQLXML call() throws SQLException {
                return conn.createSQLXML();
            }
        });
        return new FiberSQLXML(sqlXML, executor);
    }

    @Override
    @Suspendable
    public boolean isValid(final int timeout) throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<Boolean, SQLException>() {
            @Override
            public Boolean call() throws SQLException {
                return conn.isValid(timeout);
            }
        });
    }

    @Override
    @Suspendable
    public void setClientInfo(final String name, final String value) throws SQLClientInfoException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLClientInfoException>() {
            @Override
            public Void call() throws SQLClientInfoException {
                conn.setClientInfo(name, value);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public void setClientInfo(final Properties properties) throws SQLClientInfoException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLClientInfoException>() {
            @Override
            public Void call() throws SQLClientInfoException {
                conn.setClientInfo(properties);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public String getClientInfo(final String name) throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<String, SQLException>() {
            @Override
            public String call() throws SQLException {
                return conn.getClientInfo(name);
            }
        });
    }

    @Override
    @Suspendable
    public Properties getClientInfo() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<Properties, SQLException>() {
            @Override
            public Properties call() throws SQLException {
                return conn.getClientInfo();
            }
        });
    }

    @Override
    @Suspendable
    public FiberArray createArrayOf(final String typeName, final Object[] elements) throws SQLException {
        final Array array = JDBCFiberAsync.exec(executor, new CheckedCallable<Array, SQLException>() {
            @Override
            public Array call() throws SQLException {
                return conn.createArrayOf(typeName, elements);
            }
        });
        return new FiberArray(array, executor);
    }

    @Override
    @Suspendable
    public FiberStruct createStruct(final String typeName, final Object[] attributes) throws SQLException {
        final Struct struct = JDBCFiberAsync.exec(executor, new CheckedCallable<Struct, SQLException>() {
            @Override
            public Struct call() throws SQLException {
                return conn.createStruct(typeName, attributes);
            }
        });
        return new FiberStruct(struct, executor);
    }

    @Override
    @Suspendable
    public void setSchema(final String schema) throws SQLException {
        JDBCFiberAsync.exec(executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.setSchema(schema);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public String getSchema() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<String, SQLException>() {
            @Override
            public String call() throws SQLException {
                return conn.getSchema();
            }
        });
    }

    @Override
    @Suspendable
    public void abort(final Executor executor) throws SQLException {
        JDBCFiberAsync.exec(this.executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.abort(executor);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public void setNetworkTimeout(final Executor executor, final int milliseconds) throws SQLException {
        JDBCFiberAsync.exec(this.executor, new CheckedCallable<Void, SQLException>() {
            @Override
            public Void call() throws SQLException {
                conn.setNetworkTimeout(executor, milliseconds);
                return null;
            }
        });
    }

    @Override
    @Suspendable
    public int getNetworkTimeout() throws SQLException {
        return JDBCFiberAsync.exec(executor, new CheckedCallable<Integer, SQLException>() {
            @Override
            public Integer call() throws SQLException {
                return conn.getNetworkTimeout();
            }
        });
    }

    @Override
    public <T> T unwrap(final Class<T> iface) throws SQLException {
        return conn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(final Class<?> iface) throws SQLException {
        return conn.isWrapperFor(iface);
    }

    @Override
    public int hashCode() {
        return conn.hashCode();
    }

    @SuppressWarnings("EqualsWhichDoesntCheckParameterClass")
    @Override
    public boolean equals(Object obj) {
        return conn.equals(obj);
    }

    @Override
    public String toString() {
        return conn.toString();
    }
}
