/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.ws.rs.client;

import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.fibers.ws.rs.client.AsyncRs;
import co.paralleluniverse.fibers.ws.rs.client.FiberInvocation;
import java.util.Locale;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

class FiberBuilder
implements Invocation.Builder {
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String HEAD = "HEAD";
    private static final String OPTIONS = "OPTIONS";
    private static final String TRACE = "TRACE";
    final Invocation.Builder builder;

    public FiberBuilder(Invocation.Builder builder) {
        this.builder = builder;
    }

    public Invocation build(String method) {
        return new FiberInvocation(this.builder.build(method));
    }

    public Invocation build(String method, Entity<?> entity) {
        return new FiberInvocation(this.builder.build(method, entity));
    }

    public Invocation buildGet() {
        return new FiberInvocation(this.builder.buildGet());
    }

    public Invocation buildDelete() {
        return new FiberInvocation(this.builder.buildDelete());
    }

    public Invocation buildPost(Entity<?> entity) {
        return new FiberInvocation(this.builder.buildPost(entity));
    }

    public Invocation buildPut(Entity<?> entity) {
        return new FiberInvocation(this.builder.buildPut(entity));
    }

    public Invocation.Builder accept(String ... mediaTypes) {
        this.builder.accept(mediaTypes);
        return this;
    }

    public Invocation.Builder accept(MediaType ... mediaTypes) {
        this.builder.accept(mediaTypes);
        return this;
    }

    public Invocation.Builder acceptLanguage(Locale ... locales) {
        this.builder.acceptLanguage(locales);
        return this;
    }

    public Invocation.Builder acceptLanguage(String ... locales) {
        this.builder.acceptLanguage(locales);
        return this;
    }

    public Invocation.Builder acceptEncoding(String ... encodings) {
        this.builder.acceptEncoding(encodings);
        return this;
    }

    public Invocation.Builder cookie(Cookie cookie) {
        this.builder.cookie(cookie);
        return this;
    }

    public Invocation.Builder cookie(String name, String value) {
        this.builder.cookie(name, value);
        return this;
    }

    public Invocation.Builder cacheControl(CacheControl cacheControl) {
        this.builder.cacheControl(cacheControl);
        return this;
    }

    public Invocation.Builder header(String name, Object value) {
        this.builder.header(name, value);
        return this;
    }

    public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
        this.builder.headers(headers);
        return this;
    }

    public Invocation.Builder property(String name, Object value) {
        this.builder.property(name, value);
        return this;
    }

    @Suspendable
    public Response get() {
        return this.method(GET);
    }

    @Suspendable
    public <T> T get(Class<T> responseType) {
        return this.method(GET, responseType);
    }

    @Suspendable
    public <T> T get(GenericType<T> responseType) {
        return this.method(GET, responseType);
    }

    @Suspendable
    public Response put(Entity<?> entity) {
        return this.method(PUT, entity);
    }

    @Suspendable
    public <T> T put(Entity<?> entity, Class<T> responseType) {
        return this.method(PUT, entity, responseType);
    }

    @Suspendable
    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        return this.method(PUT, entity, responseType);
    }

    @Suspendable
    public Response post(Entity<?> entity) {
        return this.method(POST, entity);
    }

    @Suspendable
    public <T> T post(Entity<?> entity, Class<T> responseType) {
        return this.method(POST, entity, responseType);
    }

    @Suspendable
    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        return this.method(POST, entity, responseType);
    }

    @Suspendable
    public Response delete() {
        return this.method(DELETE);
    }

    @Suspendable
    public <T> T delete(Class<T> responseType) {
        return this.method(DELETE, responseType);
    }

    @Suspendable
    public <T> T delete(GenericType<T> responseType) {
        return this.method(DELETE, responseType);
    }

    @Suspendable
    public Response head() {
        return this.method(HEAD);
    }

    @Suspendable
    public Response options() {
        return this.method(OPTIONS);
    }

    @Suspendable
    public <T> T options(Class<T> responseType) {
        return this.method(OPTIONS, responseType);
    }

    @Suspendable
    public <T> T options(GenericType<T> responseType) {
        return this.method(OPTIONS, responseType);
    }

    @Suspendable
    public Response trace() {
        return this.method(TRACE);
    }

    @Suspendable
    public <T> T trace(Class<T> responseType) {
        return this.method(TRACE, responseType);
    }

    @Suspendable
    public <T> T trace(GenericType<T> responseType) {
        return this.method(TRACE, responseType);
    }

    @Suspendable
    public Response method(final String name) {
        try {
            return (Response)new AsyncRs<Response>(){

                protected Void requestAsync() {
                    FiberBuilder.this.builder.async().method(name, (InvocationCallback)this);
                    return null;
                }
            }.run();
        }
        catch (SuspendExecution ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Suspendable
    public <T> T method(final String name, Class<T> responseType) {
        try {
            return (T)new AsyncRs<T>(){

                protected Void requestAsync() {
                    FiberBuilder.this.builder.async().method(name, (InvocationCallback)this);
                    return null;
                }
            }.run();
        }
        catch (SuspendExecution ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Suspendable
    public <T> T method(String name, GenericType<T> responseType) {
        return this.method(name, responseType.getRawType());
    }

    @Suspendable
    public Response method(final String name, final Entity<?> entity) {
        try {
            return (Response)new AsyncRs<Response>(){

                protected Void requestAsync() {
                    FiberBuilder.this.builder.async().method(name, entity, (InvocationCallback)this);
                    return null;
                }
            }.run();
        }
        catch (SuspendExecution ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Suspendable
    public <T> T method(final String name, final Entity<?> entity, Class<T> responseType) {
        try {
            return (T)new AsyncRs<T>(){

                protected Void requestAsync() {
                    FiberBuilder.this.builder.async().method(name, entity, (InvocationCallback)this);
                    return null;
                }
            }.run();
        }
        catch (SuspendExecution ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Suspendable
    public <T> T method(final String name, final Entity<?> entity, GenericType<T> responseType) {
        try {
            return (T)new AsyncRs<T>(){

                protected Void requestAsync() {
                    FiberBuilder.this.builder.async().method(name, entity, (InvocationCallback)this);
                    return null;
                }
            }.run();
        }
        catch (SuspendExecution ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public AsyncInvoker async() {
        return this.builder.async();
    }

    public int hashCode() {
        return this.builder.hashCode();
    }

    public boolean equals(Object obj) {
        return this.builder.equals(obj);
    }

    public String toString() {
        return this.builder.toString();
    }
}

