/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.httpasyncclient;

import co.paralleluniverse.strands.SettableFuture;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class FiberCloseableHttpAsyncClient
extends CloseableHttpAsyncClient {
    private final CloseableHttpAsyncClient client;

    private FiberCloseableHttpAsyncClient(CloseableHttpAsyncClient client) {
        this.client = client;
    }

    public static CloseableHttpAsyncClient wrap(CloseableHttpAsyncClient client) {
        return new FiberCloseableHttpAsyncClient(client);
    }

    public boolean isRunning() {
        return this.client.isRunning();
    }

    public void start() {
        this.client.start();
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        SettableFuture future = new SettableFuture();
        this.client.execute(requestProducer, responseConsumer, FiberCloseableHttpAsyncClient.wrapCallbackWithFuture(future, callback));
        return future;
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        SettableFuture future = new SettableFuture();
        this.client.execute(target, request, context, FiberCloseableHttpAsyncClient.wrapCallbackWithFuture(future, callback));
        return future;
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        SettableFuture future = new SettableFuture();
        this.client.execute(target, request, FiberCloseableHttpAsyncClient.wrapCallbackWithFuture(future, callback));
        return future;
    }

    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        SettableFuture future = new SettableFuture();
        this.client.execute(request, FiberCloseableHttpAsyncClient.wrapCallbackWithFuture(future, callback));
        return future;
    }

    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        SettableFuture future = new SettableFuture();
        this.client.execute(request, context, FiberCloseableHttpAsyncClient.wrapCallbackWithFuture(future, callback));
        return future;
    }

    public void close() throws IOException {
        this.client.close();
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        SettableFuture future = new SettableFuture();
        this.client.execute(requestProducer, responseConsumer, context, FiberCloseableHttpAsyncClient.wrapCallbackWithFuture(future, callback));
        return future;
    }

    private static <T> FutureCallback<T> wrapCallbackWithFuture(final SettableFuture<T> future, final FutureCallback<T> callback) {
        return new FutureCallback<T>(){

            public void completed(T result) {
                future.set(result);
                callback.completed(result);
            }

            public void failed(Exception ex) {
                future.setException((Throwable)ex);
                callback.failed(ex);
            }

            public void cancelled() {
                future.cancel(true);
                callback.cancelled();
            }
        };
    }
}

