/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.httpclient;

import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.fibers.httpclient.AsyncHttpReq;
import co.paralleluniverse.fibers.httpclient.DelegatingHttpResponse;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;

public class FiberHttpClient
extends CloseableHttpClient {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final CloseableHttpAsyncClient client;
    private final HttpRequestRetryHandler httpRequestRetryHandler;

    public FiberHttpClient(CloseableHttpAsyncClient client) {
        this(client, null);
    }

    public FiberHttpClient(CloseableHttpAsyncClient client, HttpRequestRetryHandler httpRequestRetryHandler) {
        this.client = client;
        this.httpRequestRetryHandler = httpRequestRetryHandler;
        if (!client.isRunning()) {
            client.start();
        }
    }

    public HttpParams getParams() {
        throw new UnsupportedOperationException();
    }

    public ClientConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException();
    }

    @Suspendable
    protected final CloseableHttpResponse doExecute(final HttpHost target, final HttpRequest request, final HttpContext context) throws IOException, ClientProtocolException {
        try {
            int executionCount = 0;
            while (true) {
                try {
                    HttpResponse response = new AsyncHttpReq(){

                        protected void requestAsync() {
                            FiberHttpClient.this.client.execute(target, request, context, (FutureCallback)this);
                        }
                    }.run();
                    return new CloseableHttpResponseWrapper(response);
                }
                catch (IOException ex) {
                    if (this.httpRequestRetryHandler != null && this.httpRequestRetryHandler.retryRequest(ex, executionCount, context)) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("I/O exception (" + ex.getClass().getName() + ") caught when processing request: " + ex.getMessage()));
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)ex.getMessage(), (Throwable)ex);
                        }
                    } else {
                        throw ex;
                    }
                    this.log.info((Object)"Retrying request");
                    ++executionCount;
                    continue;
                }
                break;
            }
        }
        catch (SuspendExecution e) {
            throw new AssertionError();
        }
    }

    public void close() throws IOException {
        this.client.close();
    }

    @Suspendable
    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.doExecute(FiberHttpClient.determineTarget(request), (HttpRequest)request, context);
    }

    @Suspendable
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        throw new UnsupportedOperationException();
    }

    @Suspendable
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull((Object)request, (String)"HTTP request");
        return this.doExecute(target, request, context);
    }

    @Suspendable
    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.execute(request, (HttpContext)null);
    }

    @Suspendable
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.execute(target, request, (HttpContext)null);
    }

    @Suspendable
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(FiberHttpClient.determineTarget(request), (HttpRequest)request, responseHandler, null);
    }

    @Suspendable
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(target, request, responseHandler, null);
    }

    @Suspendable
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Object result;
        CloseableHttpResponse response = this.doExecute(target, request, context);
        try {
            result = responseHandler.handleResponse((HttpResponse)response);
        }
        catch (Exception t) {
            HttpEntity entity = response.getEntity();
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (Exception t2) {
                this.log.warn((Object)"Error consuming content after an exception.", (Throwable)t2);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        HttpEntity entity = response.getEntity();
        EntityUtils.consume((HttpEntity)entity);
        return (T)result;
    }

    private static HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost((URI)requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    private static class CloseableHttpResponseWrapper
    extends DelegatingHttpResponse
    implements CloseableHttpResponse {
        public CloseableHttpResponseWrapper(HttpResponse response) {
            super(response);
        }

        public void close() throws IOException {
            HttpEntity entity = this.response.getEntity();
            EntityUtils.consume((HttpEntity)entity);
        }
    }
}

