/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.httpclient;

import co.paralleluniverse.fibers.httpclient.FiberHttpClient;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.protocol.HttpProcessor;

public class FiberHttpClientBuilder {
    private final HttpAsyncClientBuilder builder;

    protected FiberHttpClientBuilder(HttpAsyncClientBuilder builder) {
        this.builder = builder;
    }

    public static FiberHttpClientBuilder create() {
        return FiberHttpClientBuilder.create(10);
    }

    public static FiberHttpClientBuilder create(int ioThreadCount) {
        return new FiberHttpClientBuilder(HttpAsyncClientBuilder.create().setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).build()).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(ioThreadCount).build()));
    }

    public final FiberHttpClientBuilder setConnectionManager(NHttpClientConnectionManager connManager) {
        this.builder.setConnectionManager(connManager);
        return this;
    }

    public final FiberHttpClientBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.builder.setSchemePortResolver(schemePortResolver);
        return this;
    }

    public final FiberHttpClientBuilder setMaxConnTotal(int maxConnTotal) {
        this.builder.setMaxConnTotal(maxConnTotal);
        return this;
    }

    public final FiberHttpClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.builder.setMaxConnPerRoute(maxConnPerRoute);
        return this;
    }

    public final FiberHttpClientBuilder setConnectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.builder.setConnectionReuseStrategy(reuseStrategy);
        return this;
    }

    public final FiberHttpClientBuilder setKeepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.builder.setKeepAliveStrategy(keepAliveStrategy);
        return this;
    }

    public final FiberHttpClientBuilder setUserTokenHandler(UserTokenHandler userTokenHandler) {
        this.builder.setUserTokenHandler(userTokenHandler);
        return this;
    }

    public final FiberHttpClientBuilder setTargetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
        this.builder.setTargetAuthenticationStrategy(targetAuthStrategy);
        return this;
    }

    public final FiberHttpClientBuilder setProxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
        this.builder.setProxyAuthenticationStrategy(proxyAuthStrategy);
        return this;
    }

    public final FiberHttpClientBuilder setHttpProcessor(HttpProcessor httpprocessor) {
        this.builder.setHttpProcessor(httpprocessor);
        return this;
    }

    public final FiberHttpClientBuilder addInterceptorFirst(HttpResponseInterceptor itcp) {
        this.builder.addInterceptorFirst(itcp);
        return this;
    }

    public final FiberHttpClientBuilder addInterceptorLast(HttpResponseInterceptor itcp) {
        this.builder.addInterceptorLast(itcp);
        return this;
    }

    public final FiberHttpClientBuilder addInterceptorFirst(HttpRequestInterceptor itcp) {
        this.builder.addInterceptorFirst(itcp);
        return this;
    }

    public final FiberHttpClientBuilder addInterceptorLast(HttpRequestInterceptor itcp) {
        this.builder.addInterceptorLast(itcp);
        return this;
    }

    public final FiberHttpClientBuilder setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.builder.setRoutePlanner(routePlanner);
        return this;
    }

    public final FiberHttpClientBuilder setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.builder.setRedirectStrategy(redirectStrategy);
        return this;
    }

    public final FiberHttpClientBuilder setDefaultCookieStore(CookieStore cookieStore) {
        this.builder.setDefaultCookieStore(cookieStore);
        return this;
    }

    public final FiberHttpClientBuilder setDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.builder.setDefaultCredentialsProvider(credentialsProvider);
        return this;
    }

    public final FiberHttpClientBuilder setDefaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        this.builder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
        return this;
    }

    public final FiberHttpClientBuilder setDefaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
        this.builder.setDefaultCookieSpecRegistry(cookieSpecRegistry);
        return this;
    }

    public final FiberHttpClientBuilder setUserAgent(String userAgent) {
        this.builder.setUserAgent(userAgent);
        return this;
    }

    public final FiberHttpClientBuilder setProxy(HttpHost proxy) {
        this.builder.setProxy(proxy);
        return this;
    }

    public final FiberHttpClientBuilder setSSLStrategy(SchemeIOSessionStrategy strategy) {
        this.builder.setSSLStrategy(strategy);
        return this;
    }

    public final FiberHttpClientBuilder setSSLContext(SSLContext sslcontext) {
        this.builder.setSSLContext(sslcontext);
        return this;
    }

    public final FiberHttpClientBuilder setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        this.builder.setHostnameVerifier(hostnameVerifier);
        return this;
    }

    public final FiberHttpClientBuilder setDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.builder.setDefaultHeaders(defaultHeaders);
        return this;
    }

    public final FiberHttpClientBuilder setDefaultConnectionConfig(ConnectionConfig config) {
        this.builder.setDefaultConnectionConfig(config);
        return this;
    }

    public final FiberHttpClientBuilder setDefaultRequestConfig(RequestConfig config) {
        this.builder.setDefaultRequestConfig(config);
        return this;
    }

    public final FiberHttpClientBuilder disableConnectionState() {
        this.builder.disableConnectionState();
        return this;
    }

    public final FiberHttpClientBuilder disableCookieManagement() {
        this.builder.disableCookieManagement();
        return this;
    }

    public final FiberHttpClientBuilder disableAuthCaching() {
        this.builder.disableAuthCaching();
        return this;
    }

    public final FiberHttpClientBuilder useSystemProperties() {
        this.builder.useSystemProperties();
        return this;
    }

    public CloseableHttpClient build() {
        return new FiberHttpClient(this.builder.build());
    }
}

