/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategies;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class InstrumentedNHttpClientBuilder
extends HttpAsyncClientBuilder {
    private final MetricRegistry metricRegistry;
    private final String name;
    private final HttpClientMetricNameStrategy metricNameStrategy;

    public InstrumentedNHttpClientBuilder(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy, String name) {
        this.metricRegistry = metricRegistry;
        this.metricNameStrategy = metricNameStrategy;
        this.name = name;
    }

    public InstrumentedNHttpClientBuilder(MetricRegistry metricRegistry, String name) {
        this(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY, name);
    }

    private Timer timer(HttpRequest request) {
        return this.metricRegistry.timer(this.metricNameStrategy.getNameFor(this.name, request));
    }

    public CloseableHttpAsyncClient build() {
        final CloseableHttpAsyncClient ac = super.build();
        return new CloseableHttpAsyncClient(){

            public boolean isRunning() {
                return ac.isRunning();
            }

            public void start() {
                ac.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
                Timer.Context timerContext;
                try {
                    timerContext = InstrumentedNHttpClientBuilder.this.timer(requestProducer.generateRequest()).time();
                }
                catch (IOException | HttpException ex) {
                    throw new AssertionError();
                }
                try {
                    Future future = ac.execute(requestProducer, responseConsumer, context, callback);
                    return future;
                }
                finally {
                    timerContext.stop();
                }
            }

            public void close() throws IOException {
                ac.close();
            }
        };
    }
}

