/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.dropwizard;

import co.paralleluniverse.fibers.dropwizard.InstrumentedNClientConnManager;
import co.paralleluniverse.fibers.dropwizard.InstrumentedNHttpClientBuilder;
import co.paralleluniverse.fibers.httpclient.FiberHttpClient;
import com.codahale.metrics.MetricRegistry;
import io.dropwizard.client.HttpClientConfiguration;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;

public class FiberHttpClientBuilder {
    private final MetricRegistry metricRegistry;
    private HttpClientConfiguration configuration = new HttpClientConfiguration();
    private DnsResolver resolver = new SystemDefaultDnsResolver();
    private HttpRequestRetryHandler httpRequestRetryHandler;
    private SchemeRegistry registry = SchemeRegistryFactory.createSystemDefault();

    public FiberHttpClientBuilder(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public FiberHttpClientBuilder(Environment environment) {
        this.metricRegistry = environment.metrics();
    }

    public FiberHttpClientBuilder using(HttpClientConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public FiberHttpClientBuilder using(DnsResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public FiberHttpClientBuilder using(HttpRequestRetryHandler httpRequestRetryHandler) {
        this.httpRequestRetryHandler = httpRequestRetryHandler;
        return this;
    }

    public FiberHttpClientBuilder using(SchemeRegistry registry) {
        this.registry = registry;
        return this;
    }

    public HttpClient build(String name) {
        RequestConfig createHttpParams = this.createHttpParams();
        NHttpClientConnectionManager manager = this.createConnectionManager(this.registry, name);
        InstrumentedNHttpClientBuilder clientBuilder = new InstrumentedNHttpClientBuilder(this.metricRegistry, name);
        clientBuilder.setConnectionManager(manager);
        clientBuilder.setDefaultRequestConfig(createHttpParams);
        this.setStrategiesForClient(clientBuilder);
        CloseableHttpAsyncClient client = clientBuilder.build();
        client.start();
        return new FiberHttpClient(client, this.getRetryHandler());
    }

    protected void setStrategiesForClient(HttpAsyncClientBuilder client) {
        final long keepAlive = this.configuration.getKeepAlive().toMilliseconds();
        if (keepAlive == 0L) {
            client.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        } else {
            client.setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
            client.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = super.getKeepAliveDuration(response, context);
                    return duration == -1L ? keepAlive : duration;
                }
            });
        }
    }

    private HttpRequestRetryHandler getRetryHandler() {
        return this.configuration.getRetries() == 0 ? null : (this.httpRequestRetryHandler != null ? this.httpRequestRetryHandler : new DefaultHttpRequestRetryHandler(this.configuration.getRetries(), false));
    }

    protected RequestConfig createHttpParams() {
        RequestConfig.Builder rcb = RequestConfig.custom();
        rcb.setCookieSpec("best-match");
        if (this.configuration.isCookiesEnabled()) {
            rcb.setCookieSpec("best-match");
        } else {
            rcb.setCookieSpec("ignoreCookies");
        }
        rcb.setStaleConnectionCheckEnabled(false);
        return rcb.build();
    }

    protected NHttpClientConnectionManager createConnectionManager(SchemeRegistry registry, String name) {
        Duration ttl = this.configuration.getTimeToLive();
        ConnectingIOReactor ioReactor = FiberHttpClientBuilder.createDefaultIOReactor(IOReactorConfig.custom().setSoTimeout((int)this.configuration.getTimeout().toMilliseconds()).setConnectTimeout((int)this.configuration.getConnectionTimeout().toMilliseconds()).setTcpNoDelay(true).build());
        InstrumentedNClientConnManager manager = new InstrumentedNClientConnManager(ioReactor, null, null, this.metricRegistry, FiberHttpClientBuilder.convertRegistry(this.registry), ttl.getQuantity(), ttl.getUnit(), this.resolver, name);
        manager.setDefaultMaxPerRoute(this.configuration.getMaxConnectionsPerRoute());
        manager.setMaxTotal(this.configuration.getMaxConnections());
        return manager;
    }

    private static ConnectingIOReactor createDefaultIOReactor(IOReactorConfig spec) {
        try {
            return new DefaultConnectingIOReactor(spec);
        }
        catch (IOReactorException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Registry<SchemeIOSessionStrategy> convertRegistry(SchemeRegistry oldRegistry) throws SSLInitializationException {
        SchemeRegistry baseRegistry = oldRegistry;
        Registry defaultRegistry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(SSLContexts.createDefault(), null, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER)).build();
        return defaultRegistry;
    }
}

