/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.dropwizard;

import co.paralleluniverse.fibers.jdbc.FiberDataSource;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.dropwizard.db.ManagedDataSource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;

public class FiberManagedDataSource
extends FiberDataSource
implements ManagedDataSource {
    private final ManagedDataSource myds;

    public static ManagedDataSource wrap(ManagedDataSource ds, int numThreads) {
        return FiberManagedDataSource.wrap(ds, Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("jdbc-worker-%d").setDaemon(true).build()));
    }

    public static ManagedDataSource wrap(ManagedDataSource ds, ExecutorService executor) {
        return new FiberManagedDataSource(ds, MoreExecutors.listeningDecorator((ExecutorService)executor));
    }

    protected FiberManagedDataSource(ManagedDataSource ds, ListeningExecutorService exec) {
        super((DataSource)ds, (ExecutorService)exec);
        this.myds = ds;
    }

    public void start() throws Exception {
        this.myds.start();
    }

    public void stop() throws Exception {
        this.myds.stop();
    }
}

