/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.dropwizard;

import co.paralleluniverse.fibers.dropwizard.FiberManagedDataSource;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.util.Duration;
import java.util.Map;

public class FiberDataSourceFactory
extends DataSourceFactory {
    private final DataSourceFactory dsf;

    public FiberDataSourceFactory(DataSourceFactory dsf) {
        this.dsf = dsf;
    }

    public ManagedDataSource build(MetricRegistry metricRegistry, String name) {
        ManagedDataSource ds = this.dsf.build(metricRegistry, name);
        return this.dsf.getUrl().startsWith("jdbc:fiber:") ? ds : FiberManagedDataSource.wrap(ds, 10);
    }

    public boolean isAutoCommentsEnabled() {
        return this.dsf.isAutoCommentsEnabled();
    }

    public void setAutoCommentsEnabled(boolean autoCommentsEnabled) {
        this.dsf.setAutoCommentsEnabled(autoCommentsEnabled);
    }

    public String getDriverClass() {
        return this.dsf.getDriverClass();
    }

    public void setDriverClass(String driverClass) {
        this.dsf.setDriverClass(driverClass);
    }

    public String getUser() {
        return this.dsf.getUser();
    }

    public void setUser(String user) {
        this.dsf.setUser(user);
    }

    public String getPassword() {
        return this.dsf.getPassword();
    }

    public void setPassword(String password) {
        this.dsf.setPassword(password);
    }

    public String getUrl() {
        return this.dsf.getUrl();
    }

    public void setUrl(String url) {
        this.dsf.setUrl(url);
    }

    public Map<String, String> getProperties() {
        return this.dsf.getProperties();
    }

    public void setProperties(Map<String, String> properties) {
        this.dsf.setProperties(properties);
    }

    public Duration getMaxWaitForConnection() {
        return this.dsf.getMaxWaitForConnection();
    }

    public void setMaxWaitForConnection(Duration maxWaitForConnection) {
        this.dsf.setMaxWaitForConnection(maxWaitForConnection);
    }

    public String getValidationQuery() {
        return this.dsf.getValidationQuery();
    }

    public void setValidationQuery(String validationQuery) {
        this.dsf.setValidationQuery(validationQuery);
    }

    public int getMinSize() {
        return this.dsf.getMinSize();
    }

    public void setMinSize(int minSize) {
        this.dsf.setMinSize(minSize);
    }

    public int getMaxSize() {
        return this.dsf.getMaxSize();
    }

    public void setMaxSize(int maxSize) {
        this.dsf.setMaxSize(maxSize);
    }

    public boolean getCheckConnectionWhileIdle() {
        return this.dsf.getCheckConnectionWhileIdle();
    }

    public void setCheckConnectionWhileIdle(boolean checkConnectionWhileIdle) {
        this.dsf.setCheckConnectionWhileIdle(checkConnectionWhileIdle);
    }

    public boolean isDefaultReadOnly() {
        return this.dsf.isDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.dsf.setDefaultReadOnly(defaultReadOnly);
    }

    public boolean isMinSizeLessThanMaxSize() {
        return this.dsf.isMinSizeLessThanMaxSize();
    }

    public boolean isInitialSizeLessThanMaxSize() {
        return this.dsf.isInitialSizeLessThanMaxSize();
    }

    public boolean isInitialSizeGreaterThanMinSize() {
        return this.dsf.isInitialSizeGreaterThanMinSize();
    }

    public int getAbandonWhenPercentageFull() {
        return this.dsf.getAbandonWhenPercentageFull();
    }

    public void setAbandonWhenPercentageFull(int percentage) {
        this.dsf.setAbandonWhenPercentageFull(percentage);
    }

    public boolean isAlternateUsernamesAllowed() {
        return this.dsf.isAlternateUsernamesAllowed();
    }

    public void setAlternateUsernamesAllowed(boolean allow) {
        this.dsf.setAlternateUsernamesAllowed(allow);
    }

    public boolean getCommitOnReturn() {
        return this.dsf.getCommitOnReturn();
    }

    public void setCommitOnReturn(boolean commitOnReturn) {
        this.dsf.setCommitOnReturn(commitOnReturn);
    }

    public Boolean getAutoCommitByDefault() {
        return this.dsf.getAutoCommitByDefault();
    }

    public void setAutoCommitByDefault(Boolean autoCommit) {
        this.dsf.setAutoCommitByDefault(autoCommit);
    }

    public String getDefaultCatalog() {
        return this.dsf.getDefaultCatalog();
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.dsf.setDefaultCatalog(defaultCatalog);
    }

    public Boolean getReadOnlyByDefault() {
        return this.dsf.getReadOnlyByDefault();
    }

    public void setReadOnlyByDefault(Boolean readOnlyByDefault) {
        this.dsf.setReadOnlyByDefault(readOnlyByDefault);
    }

    public DataSourceFactory.TransactionIsolation getDefaultTransactionIsolation() {
        return this.dsf.getDefaultTransactionIsolation();
    }

    public void setDefaultTransactionIsolation(DataSourceFactory.TransactionIsolation isolation) {
        this.dsf.setDefaultTransactionIsolation(isolation);
    }

    public boolean getUseFairQueue() {
        return this.dsf.getUseFairQueue();
    }

    public void setUseFairQueue(boolean fair) {
        this.dsf.setUseFairQueue(fair);
    }

    public int getInitialSize() {
        return this.dsf.getInitialSize();
    }

    public void setInitialSize(int initialSize) {
        this.dsf.setInitialSize(initialSize);
    }

    public String getInitializationQuery() {
        return this.dsf.getInitializationQuery();
    }

    public void setInitializationQuery(String query) {
        this.dsf.setInitializationQuery(query);
    }

    public boolean getLogAbandonedConnections() {
        return this.dsf.getLogAbandonedConnections();
    }

    public void setLogAbandonedConnections(boolean log) {
        this.dsf.setLogAbandonedConnections(log);
    }

    public boolean getLogValidationErrors() {
        return this.dsf.getLogValidationErrors();
    }

    public void setLogValidationErrors(boolean log) {
        this.dsf.setLogValidationErrors(log);
    }

    public Optional<Duration> getMaxConnectionAge() {
        return this.dsf.getMaxConnectionAge();
    }

    public void setMaxConnectionAge(Duration age) {
        this.dsf.setMaxConnectionAge(age);
    }

    public Duration getMinIdleTime() {
        return this.dsf.getMinIdleTime();
    }

    public void setMinIdleTime(Duration time) {
        this.dsf.setMinIdleTime(time);
    }

    public boolean getCheckConnectionOnBorrow() {
        return this.dsf.getCheckConnectionOnBorrow();
    }

    public void setCheckConnectionOnBorrow(boolean checkConnectionOnBorrow) {
        this.dsf.setCheckConnectionOnBorrow(checkConnectionOnBorrow);
    }

    public boolean getCheckConnectionOnConnect() {
        return this.dsf.getCheckConnectionOnConnect();
    }

    public void setCheckConnectionOnConnect(boolean checkConnectionOnConnect) {
        this.dsf.setCheckConnectionOnConnect(checkConnectionOnConnect);
    }

    public boolean getCheckConnectionOnReturn() {
        return this.dsf.getCheckConnectionOnReturn();
    }

    public void setCheckConnectionOnReturn(boolean checkConnectionOnReturn) {
        this.dsf.setCheckConnectionOnReturn(checkConnectionOnReturn);
    }

    public Duration getEvictionInterval() {
        return this.dsf.getEvictionInterval();
    }

    public void setEvictionInterval(Duration interval) {
        this.dsf.setEvictionInterval(interval);
    }

    public Duration getValidationInterval() {
        return this.dsf.getValidationInterval();
    }

    public void setValidationInterval(Duration validationInterval) {
        this.dsf.setValidationInterval(validationInterval);
    }
}

