/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.dropwizard;

import co.paralleluniverse.fibers.dropwizard.FiberDataSourceFactory;
import co.paralleluniverse.fibers.dropwizard.FiberManagedDataSource;
import co.paralleluniverse.fibers.jdbi.FiberDBI;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;

public class FiberDBIFactory {
    private final ExecutorService es;
    private final DBIFactory builder = new DBIFactory();

    public FiberDBIFactory(ExecutorService es) {
        this.es = es;
    }

    public FiberDBIFactory(int threadsNum) {
        this(Executors.newFixedThreadPool(threadsNum, new ThreadFactoryBuilder().setNameFormat("jdbc-worker-%d").setDaemon(true).build()));
    }

    public FiberDBIFactory() {
        this(10);
    }

    public IDBI build(Environment environment, DataSourceFactory dsFactory, ManagedDataSource dataSource, String name) {
        DBI build = this.builder.build(environment, (DataSourceFactory)new FiberDataSourceFactory(dsFactory), FiberManagedDataSource.wrap(dataSource, this.es), name);
        return new FiberDBI((IDBI)build);
    }

    public IDBI build(Environment environment, DataSourceFactory dsFactory, String name) throws ClassNotFoundException {
        DBI build = this.builder.build(environment, (DataSourceFactory)new FiberDataSourceFactory(dsFactory), name);
        return new FiberDBI((IDBI)build);
    }
}

