/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.undertow;

import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ExitMessage;
import co.paralleluniverse.actors.FakeActor;
import co.paralleluniverse.actors.LifecycleMessage;
import co.paralleluniverse.actors.ShutdownMessage;
import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.comsat.webactors.Cookie;
import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.HttpResponse;
import co.paralleluniverse.comsat.webactors.HttpStreamOpened;
import co.paralleluniverse.comsat.webactors.WebActor;
import co.paralleluniverse.comsat.webactors.WebDataMessage;
import co.paralleluniverse.comsat.webactors.WebMessage;
import co.paralleluniverse.comsat.webactors.WebSocketOpened;
import co.paralleluniverse.comsat.webactors.undertow.ByteArrayReadChannelListener;
import co.paralleluniverse.comsat.webactors.undertow.HttpRequestWrapper;
import co.paralleluniverse.comsat.webactors.undertow.StringWriteChannelListener;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberUtil;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.SuspendableRunnable;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.SendPort;
import co.paralleluniverse.strands.concurrent.ReentrantLock;
import io.undertow.Handlers;
import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

public class WebActorHandler
implements HttpHandler {
    protected static final String ACTOR_KEY = "co.paralleluniverse.comsat.webactors.sessionActor";
    static final WeakHashMap<Class<?>, List<Pair<String, String>>> classToUrlPatterns = new WeakHashMap();
    private final ContextProvider selector;

    public WebActorHandler(ContextProvider selector) {
        this.selector = selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleRequest(HttpServerExchange xch) throws Exception {
        Context context = this.selector.get(xch);
        assert (context != null);
        ReentrantLock lock = context.getLock();
        assert (lock != null);
        lock.lock();
        try {
            final ActorRef<? extends WebMessage> userActorRef = context.getRef();
            Object internalActor = (ActorImpl)context.getAttachments().get(ACTOR_KEY);
            String uri = xch.getRequestURI();
            if (userActorRef != null) {
                if (context.handlesWithWebSocket(uri)) {
                    if (internalActor == null || !(internalActor instanceof WebSocketActorAdapter)) {
                        ActorRef<? extends WebMessage> userActorRef0 = userActorRef;
                        internalActor = new WebSocketActorAdapter(userActorRef0);
                        WebActorHandler.addActorToContextAndUnlock(context, internalActor, lock);
                    }
                    final WebSocketActorAdapter webSocketActor = (WebSocketActorAdapter)((Object)internalActor);
                    xch.dispatch();
                    Handlers.websocket((WebSocketConnectionCallback)new WebSocketConnectionCallback(){

                        public final void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                            webSocketActor.setChannel(channel);
                            channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                                protected final void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                                    webSocketActor.onMessage(message);
                                }

                                protected final void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                                    webSocketActor.onMessage(message);
                                }
                            });
                            channel.resumeReceives();
                            try {
                                FiberUtil.runInFiber((SuspendableRunnable)new SuspendableRunnable(){

                                    public final void run() throws SuspendExecution, InterruptedException {
                                        userActorRef.send((Object)new WebSocketOpened(webSocketActor.ref()));
                                    }
                                });
                            }
                            catch (InterruptedException | ExecutionException e) {
                                UndertowLogger.ROOT_LOGGER.error((Object)"Exception while sending `WebSocketOpened` message to actor", (Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }
                    }).handleRequest(xch);
                    return;
                }
                if (context.handlesWithHttp(uri)) {
                    if (internalActor == null || !(internalActor instanceof HttpActorAdapter)) {
                        internalActor = new HttpActorAdapter(userActorRef, context);
                        WebActorHandler.addActorToContextAndUnlock(context, internalActor, lock);
                    }
                    ((HttpActorAdapter)((Object)internalActor)).service(xch);
                    return;
                }
            }
            WebActorHandler.sendHttpResponse(xch, 404);
        }
        finally {
            if (lock.isHeldByCurrentStrand() && lock.isLocked()) {
                lock.unlock();
            }
        }
    }

    static void addActorToContextAndUnlock(Context context, ActorImpl actor, ReentrantLock lock) {
        context.getAttachments().put(ACTOR_KEY, actor);
        lock.unlock();
    }

    static void sendHttpResponse(HttpServerExchange xch, int statusCode) {
        WebActorHandler.sendHttpResponse(xch, statusCode, (String)null);
    }

    static void sendHttpResponse(HttpServerExchange xch, int statusCode, String body) {
        xch.setStatusCode(statusCode);
        if (body != null) {
            xch.getResponseSender().send(body);
        }
        xch.endExchange();
    }

    static void sendHttpResponse(HttpServerExchange xch, int statusCode, ByteBuffer body) {
        xch.setStatusCode(statusCode);
        if (body != null) {
            xch.getResponseSender().send(body);
        }
        xch.endExchange();
    }

    static void sendHttpRedirect(HttpServerExchange xch, String path) {
        xch.setStatusCode(302);
        xch.getResponseHeaders().add(Headers.LOCATION, xch.getProtocol() + "://" + xch.getHostAndPort() + path);
        xch.endExchange();
    }

    static boolean handlesWithHttp(String uri, Class<?> actorClass) {
        return WebActorHandler.match(uri, actorClass).equals("http");
    }

    static boolean handlesWithWebSocket(String uri, Class<?> actorClass) {
        return WebActorHandler.match(uri, actorClass).equals("ws");
    }

    private static String match(String uri, Class<?> actorClass) {
        if (uri != null && actorClass != null) {
            for (Pair<String, String> e : WebActorHandler.lookupOrInsert(actorClass)) {
                if (!WebActorHandler.servletMatch((String)e.getFirst(), uri)) continue;
                return (String)e.getSecond();
            }
        }
        return "";
    }

    private static List<Pair<String, String>> lookupOrInsert(Class<?> actorClass) {
        if (actorClass != null) {
            List<Pair<String, String>> lookup = classToUrlPatterns.get(actorClass);
            if (lookup != null) {
                return lookup;
            }
            return WebActorHandler.insert(actorClass);
        }
        return null;
    }

    private static List<Pair<String, String>> insert(Class<?> actorClass) {
        if (actorClass != null) {
            WebActor wa = actorClass.getAnnotation(WebActor.class);
            ArrayList<Pair<String, String>> ret = new ArrayList<Pair<String, String>>(4);
            for (String httpP : wa.httpUrlPatterns()) {
                WebActorHandler.addPattern(ret, httpP, "http");
            }
            for (String wsP : wa.webSocketUrlPatterns()) {
                WebActorHandler.addPattern(ret, wsP, "ws");
            }
            classToUrlPatterns.put(actorClass, ret);
            return ret;
        }
        return null;
    }

    private static void addPattern(List<Pair<String, String>> ret, String p, String type) {
        if (p != null) {
            Pair entry = new Pair((Object)p, (Object)type);
            if (p.endsWith("*") || p.startsWith("*.") || p.equals("/")) {
                ret.add((Pair<String, String>)entry);
            } else {
                ret.add(0, (Pair<String, String>)entry);
            }
        }
    }

    private static boolean servletMatch(String pattern, String uri) {
        if (pattern != null && uri != null) {
            if (pattern.startsWith("/") && pattern.endsWith("*")) {
                return uri.startsWith(pattern.substring(0, pattern.length() - 1));
            }
            if (pattern.startsWith("*.")) {
                return uri.endsWith(pattern.substring(2));
            }
            if (pattern.isEmpty()) {
                return uri.equals("/");
            }
            return pattern.equals("/") || pattern.equals(uri);
        }
        return false;
    }

    private static ByteBuffer toBuffer(ByteBuffer ... payload) {
        if (payload.length == 1) {
            return payload[0];
        }
        int size = (int)Buffers.remaining((Buffer[])payload);
        if (size == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer buf : payload) {
            buffer.put(buf);
        }
        buffer.flip();
        return buffer;
    }

    private static final class HttpStreamChannelAdapter
    implements SendPort<WebDataMessage> {
        private final HttpServerExchange xch;
        private StreamSinkChannel channel;
        HttpStreamActorAdapter actor;

        HttpStreamChannelAdapter(HttpServerExchange xch) {
            this.xch = xch;
        }

        public final void setChannel(StreamSinkChannel channel) {
            this.channel = channel;
        }

        public final void send(WebDataMessage message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        public final boolean send(WebDataMessage message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            this.send(message);
            return true;
        }

        public final boolean send(WebDataMessage message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        public final boolean trySend(WebDataMessage res) {
            String stringBody = res.getStringBody();
            String charset = this.xch.getRequestCharset();
            StringWriteChannelListener l = stringBody != null ? (charset != null ? new StringWriteChannelListener(stringBody, Charset.forName(charset)) : new StringWriteChannelListener(stringBody)) : new StringWriteChannelListener(res.getByteBufferBody());
            l.setup(this.channel);
            return true;
        }

        public final void close() {
            this.xch.endExchange();
            if (this.actor != null) {
                this.actor.die(null);
            }
        }

        public final void close(Throwable t) {
            if (this.actor != null) {
                this.actor.die(t);
            }
            this.close();
        }
    }

    private static final class HttpStreamActorAdapter
    extends FakeActor<WebDataMessage> {
        private HttpStreamChannelAdapter adapter = (HttpStreamChannelAdapter)this.mailbox();
        private volatile boolean dead;

        HttpStreamActorAdapter(HttpServerExchange xch) {
            super(xch.toString(), (SendPort)new HttpStreamChannelAdapter(xch));
            this.adapter.actor = this;
        }

        protected final WebDataMessage handleLifecycleMessage(LifecycleMessage m) {
            if (m instanceof ShutdownMessage) {
                this.die(null);
            }
            return null;
        }

        protected final void throwIn(RuntimeException e) {
            this.die(e);
        }

        public final void interrupt() {
            this.die(new InterruptedException());
        }

        protected final void die(Throwable cause) {
            if (this.dead) {
                return;
            }
            this.dead = true;
            this.mailbox().close();
            super.die(cause);
            this.adapter = null;
        }

        public final String toString() {
            return "HttpStreamActorAdapter{request + " + this.getName() + "}";
        }

        public final void setChannel(StreamSinkChannel channel) {
            this.adapter.setChannel(channel);
        }
    }

    private static final class HttpChannelAdapter
    implements SendPort<HttpResponse> {
        static final HttpChannelAdapter INSTANCE = new HttpChannelAdapter();
        private HttpActorAdapter actor;

        HttpChannelAdapter() {
        }

        public final void send(HttpResponse message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        public final boolean send(HttpResponse message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            this.send(message);
            return true;
        }

        public final boolean send(HttpResponse message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean trySend(final HttpResponse message) {
            try {
                boolean sseStarted;
                HttpRequestWrapper undertowRequest = (HttpRequestWrapper)message.getRequest();
                HttpServerExchange xch = undertowRequest.xch;
                int status = message.getStatus();
                if (status >= 400 && status < 600) {
                    WebActorHandler.sendHttpResponse(xch, status);
                    this.close();
                    boolean bl = true;
                    return bl;
                }
                if (message.getRedirectPath() != null) {
                    WebActorHandler.sendHttpRedirect(xch, message.getRedirectPath());
                    this.close();
                    boolean bl = true;
                    return bl;
                }
                if (message.getCookies() != null) {
                    for (Object c : message.getCookies()) {
                        xch.setResponseCookie(this.newUndertowCookie((Cookie)c));
                    }
                }
                HeaderMap heads = xch.getResponseHeaders();
                if (message.getHeaders() != null) {
                    for (String k : message.getHeaders().keys()) {
                        heads.putAll(new HttpString(k), message.getHeaderValues(k));
                    }
                }
                if (message.getContentType() != null) {
                    String ct = message.getContentType();
                    if (message.getCharacterEncoding() != null) {
                        ct = ct + "; charset=" + message.getCharacterEncoding().name();
                    }
                    xch.getResponseHeaders().add(Headers.CONTENT_TYPE, ct);
                }
                if (sseStarted = message.shouldStartActor()) {
                    try {
                        xch.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/event-stream; charset=UTF-8");
                        xch.setPersistent(false);
                        StreamSinkChannel sink = xch.getResponseChannel();
                        final HttpStreamActorAdapter httpStreamActorAdapter = new HttpStreamActorAdapter(xch);
                        if (!sink.flush()) {
                            sink.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                                public final void handleEvent(final StreamSinkChannel channel) {
                                    try {
                                        FiberUtil.runInFiber((SuspendableRunnable)new SuspendableRunnable(){

                                            public void run() throws SuspendExecution, InterruptedException {
                                                HttpChannelAdapter.this.handleSSEStart(httpStreamActorAdapter, message, channel);
                                            }
                                        });
                                    }
                                    catch (InterruptedException | ExecutionException e) {
                                        UndertowLogger.ROOT_LOGGER.error((Object)"Exception while handling SSE start response event", (Throwable)e);
                                        throw new RuntimeException(e);
                                    }
                                }
                            }, null));
                            sink.resumeWrites();
                        }
                        this.handleSSEStart(httpStreamActorAdapter, message, sink);
                    }
                    catch (Exception e) {
                        UndertowLogger.ROOT_LOGGER.error((Object)"Exception while sending SSE start response", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                } else if (message.getStringBody() != null) {
                    WebActorHandler.sendHttpResponse(xch, status, message.getStringBody());
                } else if (message.getByteBufferBody() != null) {
                    WebActorHandler.sendHttpResponse(xch, status, message.getByteBufferBody());
                } else {
                    WebActorHandler.sendHttpResponse(xch, status);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (this.actor != null) {
                    this.actor.unwatch();
                }
            }
        }

        private void handleSSEStart(HttpStreamActorAdapter httpStreamActorAdapter, HttpResponse message, StreamSinkChannel channel) throws SuspendExecution {
            httpStreamActorAdapter.setChannel(channel);
            message.getFrom().send((Object)new HttpStreamOpened(httpStreamActorAdapter.ref(), message));
        }

        private io.undertow.server.handlers.Cookie newUndertowCookie(Cookie c) {
            CookieImpl ret = new CookieImpl(c.getName(), c.getValue());
            ret.setComment(c.getComment());
            ret.setDomain(c.getDomain());
            ret.setHttpOnly(c.isHttpOnly());
            ret.setMaxAge(Integer.valueOf(c.getMaxAge()));
            ret.setPath(c.getPath());
            ret.setVersion(c.getVersion());
            ret.setSecure(c.isSecure());
            return ret;
        }

        public final void close() {
            if (this.actor != null) {
                this.actor.die(null);
            }
        }

        public final void close(Throwable t) {
            UndertowLogger.ROOT_LOGGER.error((Object)"Exception while closing HTTP adapter", t);
            if (this.actor != null) {
                this.actor.die(t);
            }
        }
    }

    private static final class HttpActorAdapter
    extends FakeActor<HttpResponse> {
        private ActorRef<? super HttpRequest> userActor;
        private Context context;
        private volatile boolean dead;
        private volatile HttpServerExchange xch;
        private volatile Object watchToken;

        HttpActorAdapter(ActorRef<? super HttpRequest> userActor, Context actorContext) {
            super("HttpActorAdapter", (SendPort)(actorContext.watch() ? new HttpChannelAdapter() : HttpChannelAdapter.INSTANCE));
            if (actorContext.watch()) {
                ((HttpChannelAdapter)this.getMailbox()).actor = this;
            }
            this.userActor = userActor;
            this.context = actorContext;
        }

        final void service(HttpServerExchange xch) throws SuspendExecution {
            this.xch = xch;
            if (this.context.watch()) {
                this.watchToken = this.watch(this.userActor);
            }
            if (this.isDone()) {
                this.handleDeath(this.getDeathCause());
                return;
            }
            new HttpByteArrayReadChannelListener((ActorRef<HttpResponse>)this.ref(), xch, this.userActor).setup(xch.getRequestChannel());
        }

        private void handleDeath(Throwable cause) {
            if (cause != null) {
                WebActorHandler.sendHttpResponse(this.xch, 500, "Actor is dead because of " + cause.getMessage());
            } else {
                WebActorHandler.sendHttpResponse(this.xch, 500, "Actor has terminated");
            }
        }

        final void unwatch() {
            if (this.watchToken != null && this.userActor != null) {
                this.unwatch(this.userActor, this.watchToken);
                this.watchToken = null;
            }
        }

        protected final HttpResponse handleLifecycleMessage(LifecycleMessage m) {
            ExitMessage em;
            if (m instanceof ExitMessage && (em = (ExitMessage)m).getActor() != null && em.getActor().equals(this.userActor)) {
                this.handleDeath(em.getCause());
                this.die(em.getCause());
            }
            return null;
        }

        protected void die(Throwable cause) {
            if (this.dead) {
                return;
            }
            this.dead = true;
            super.die(cause);
            try {
                this.context.invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unwatch();
            this.userActor = null;
            this.watchToken = null;
            this.context = null;
            this.xch = null;
        }

        protected final void throwIn(RuntimeException e) {
            this.die(e);
        }

        protected final void interrupt() {
            this.die(new InterruptedException());
        }

        public final String toString() {
            return "HttpActorAdapter{" + this.userActor + "}";
        }

        private static final class HttpByteArrayReadChannelListener
        extends ByteArrayReadChannelListener {
            private final HttpServerExchange xch;
            private final ActorRef<? super HttpRequest> userActor;
            private final ActorRef<HttpResponse> from;

            public HttpByteArrayReadChannelListener(ActorRef<HttpResponse> from, HttpServerExchange xch, ActorRef<? super HttpRequest> userActor) {
                super(xch.getConnection().getByteBufferPool());
                this.xch = xch;
                this.userActor = userActor;
                this.from = from;
            }

            @Override
            protected final void byteArrayDone(byte[] ba) {
                this.xch.dispatch();
                new Fiber((SuspendableRunnable)new RequestSending(this.from, this.userActor, this.xch, ba)).start();
            }

            @Override
            protected final void error(IOException e) {
                UndertowLogger.ROOT_LOGGER.error((Object)"Exception while reading HTTP request", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        private static final class RequestSending
        implements SuspendableRunnable {
            private final ActorRef from;
            private final ActorRef<? super HttpRequest> userActor;
            private final HttpServerExchange xch;
            private final byte[] ba;

            public RequestSending(ActorRef from, ActorRef<? super HttpRequest> userActor, HttpServerExchange xch, byte[] ba) {
                this.from = from;
                this.userActor = userActor;
                this.xch = xch;
                this.ba = ba;
            }

            public final void run() throws SuspendExecution, InterruptedException {
                this.userActor.send((Object)new HttpRequestWrapper((ActorRef<? super HttpResponse>)this.from, this.xch, ByteBuffer.wrap(this.ba)));
            }
        }
    }

    private static final class WebSocketChannelAdapter
    implements SendPort<WebDataMessage> {
        WebSocketChannel channel;
        WebSocketActorAdapter actor;

        private WebSocketChannelAdapter() {
        }

        public final void send(WebDataMessage message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        public final boolean send(WebDataMessage message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            return this.trySend(message);
        }

        public final boolean send(WebDataMessage message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        public final boolean trySend(WebDataMessage message) {
            if (!message.isBinary()) {
                WebSockets.sendText((String)message.getStringBody(), (WebSocketChannel)this.channel, null);
            } else {
                WebSockets.sendBinary((ByteBuffer)message.getByteBufferBody(), (WebSocketChannel)this.channel, null);
            }
            return true;
        }

        public final void close() {
            try {
                this.channel.sendClose();
            }
            catch (IOException e) {
                UndertowLogger.ROOT_LOGGER.error((Object)"Exception while closing websocket channel", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                if (this.actor != null) {
                    this.actor.die(null);
                }
            }
        }

        public final void close(Throwable t) {
            if (this.actor != null) {
                this.actor.die(t);
            }
            this.close();
        }
    }

    private static final class WebSocketActorAdapter
    extends FakeActor<WebDataMessage> {
        ActorRef<? super WebMessage> userActor;
        private WebSocketChannelAdapter adapter = (WebSocketChannelAdapter)this.mailbox();
        private WebSocketChannel channel;

        public WebSocketActorAdapter(ActorRef<? super WebMessage> userActor) {
            super(userActor.getName(), (SendPort)new WebSocketChannelAdapter());
            this.adapter.actor = this;
            this.userActor = userActor;
            this.watch(userActor);
        }

        final void setChannel(WebSocketChannel channel) {
            this.channel = channel;
            this.adapter.channel = channel;
        }

        final void onMessage(BufferedBinaryMessage message) {
            try {
                this.userActor.send((Object)new WebDataMessage(this.ref(), WebActorHandler.toBuffer((ByteBuffer[])message.getData().getResource()).duplicate()));
            }
            catch (SuspendExecution ex) {
                throw new AssertionError((Object)ex);
            }
        }

        final void onMessage(BufferedTextMessage message) {
            try {
                this.userActor.send((Object)new WebDataMessage(this.ref(), message.getData()));
            }
            catch (SuspendExecution ex) {
                throw new AssertionError((Object)ex);
            }
        }

        protected final WebDataMessage handleLifecycleMessage(LifecycleMessage m) {
            ExitMessage em;
            if (m instanceof ExitMessage && (em = (ExitMessage)m).getActor() != null && em.getActor().equals(this.userActor)) {
                this.die(em.getCause());
            }
            return null;
        }

        protected final void throwIn(RuntimeException e) {
            this.die(e);
        }

        public final void interrupt() {
            this.die(new InterruptedException());
        }

        protected final void die(Throwable cause) {
            super.die(cause);
            try {
                this.channel.sendClose();
            }
            catch (IOException e) {
                UndertowLogger.ROOT_LOGGER.error((Object)"Exception while closing websocket channel during actor death", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                this.adapter = null;
                this.userActor = null;
                this.channel = null;
            }
        }

        public final String toString() {
            return "WebSocketActor{userActor=" + this.userActor + '}';
        }
    }

    public static abstract class DefaultContextImpl
    implements Context {
        private static final String durationProp = System.getProperty(DefaultContextImpl.class.getName() + ".durationMillis");
        private static final long DURATION = durationProp != null ? Long.parseLong(durationProp) : 60000L;
        final Map<String, Object> attachments = new HashMap<String, Object>();
        private final ReentrantLock lock = new ReentrantLock();
        private final long created = new Date().getTime();
        private boolean valid = true;

        @Override
        public final void invalidate() {
            this.attachments.clear();
            this.valid = false;
        }

        @Override
        public final boolean isValid() {
            boolean ret;
            boolean bl = ret = this.valid && new Date().getTime() - this.created <= DURATION;
            if (!ret) {
                this.invalidate();
            }
            return ret;
        }

        @Override
        public final Map<String, Object> getAttachments() {
            return this.attachments;
        }

        @Override
        public final ReentrantLock getLock() {
            return this.lock;
        }

        @Override
        public boolean watch() {
            return true;
        }
    }

    public static interface Context {
        public boolean isValid();

        public void invalidate();

        public ActorRef<? extends WebMessage> getRef();

        public ReentrantLock getLock();

        public Map<String, Object> getAttachments();

        public boolean handlesWithWebSocket(String var1);

        public boolean handlesWithHttp(String var1);

        public boolean watch();
    }

    public static interface ContextProvider {
        public Context get(HttpServerExchange var1);
    }
}

