/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.undertow;

import io.undertow.UndertowLogger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

public final class StringWriteChannelListener
implements ChannelListener<StreamSinkChannel> {
    private ByteBuffer buffer;

    public StringWriteChannelListener(String string) {
        this(string, Charset.defaultCharset());
    }

    public StringWriteChannelListener(String string, Charset charset) {
        this.buffer = ByteBuffer.wrap(string.getBytes(charset));
    }

    public StringWriteChannelListener(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public final void setup(StreamSinkChannel channel) {
        this.partialWrite(channel, true);
    }

    public final void handleEvent(StreamSinkChannel channel) {
        this.partialWrite(channel, false);
    }

    private void partialWrite(StreamSinkChannel c, boolean setup) {
        block7: {
            if (this.buffer == null) {
                return;
            }
            try {
                int writeCount;
                do {
                    writeCount = c.write(this.buffer);
                } while (this.buffer.hasRemaining() && writeCount > 0);
                if (this.buffer.hasRemaining()) {
                    if (setup) {
                        c.getWriteSetter().set((ChannelListener)this);
                    }
                    c.resumeWrites();
                } else {
                    this.writeDone(c);
                }
            }
            catch (Throwable t) {
                this.handleError(c, "Error in 'partialWrite(setup = " + setup + ")'", t);
                if (t instanceof IOException) break block7;
                throw new RuntimeException(t);
            }
        }
    }

    private void writeDone(final StreamSinkChannel c) {
        block3: {
            try {
                this.cleanup();
                c.shutdownWrites();
                if (!c.flush()) {
                    c.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                        public final void handleEvent(StreamSinkChannel o) {
                            IoUtils.safeClose((Closeable)c);
                        }
                    }, (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
                    c.resumeWrites();
                }
            }
            catch (Throwable t) {
                this.handleError(c, "Error in 'writeDone'", t);
                if (t instanceof IOException) break block3;
                throw new RuntimeException(t);
            }
        }
    }

    private void handleError(StreamSinkChannel c, String m, Throwable t) {
        if (t instanceof IOException) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)t);
        } else {
            UndertowLogger.REQUEST_IO_LOGGER.error((Object)m, t);
        }
        this.cleanup();
        c.getWriteSetter().set(null);
        IoUtils.safeClose((Closeable)c);
    }

    private void cleanup() {
        if (this.buffer != null) {
            this.buffer = null;
        }
    }
}

